/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components;

import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.util.Simulation;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class WirelessChargingComponent
implements IComponent.ServerOnly {
    private final MachineBlockEntity machine;
    private final EnergyComponent energy;
    private final BiPredicate<MachineBlockEntity, Player> filter;
    private final Supplier<Long> maxEuTransfer;

    public WirelessChargingComponent(MachineBlockEntity machine, EnergyComponent energy, BiPredicate<MachineBlockEntity, Player> filter, Supplier<Long> maxEuTransfer) {
        this.machine = machine;
        this.energy = energy;
        this.filter = filter;
        this.maxEuTransfer = maxEuTransfer;
    }

    private UUID getPlacerId() {
        return this.machine.placedBy.placerId;
    }

    public Optional<Player> getPlayer() {
        ServerPlayer player = this.machine.getLevel().getServer().getPlayerList().getPlayer(this.getPlacerId());
        return player == null || !this.filter.test(this.machine, (Player)player) ? Optional.empty() : Optional.of(player);
    }

    private long charge(Player player, long maxEu) {
        ILongEnergyStorage energy;
        Inventory inventory = player.getInventory();
        long eu = 0L;
        for (ItemStack armor : inventory.armor) {
            energy = (ILongEnergyStorage)armor.getCapability(EnergyApi.ITEM);
            if (energy == null || (eu += energy.receive(Math.max(0L, maxEu - eu), false)) != maxEu) continue;
            return eu;
        }
        for (ItemStack item : inventory.items) {
            energy = (ILongEnergyStorage)item.getCapability(EnergyApi.ITEM);
            if (energy == null || (eu += energy.receive(Math.max(0L, maxEu - eu), false)) != maxEu) continue;
            return eu;
        }
        return eu;
    }

    public void tick() {
        Optional<Player> playerOptional = this.getPlayer();
        if (playerOptional.isPresent()) {
            Player player = playerOptional.get();
            long eu = this.maxEuTransfer.get();
            eu = this.energy.consumeEu(eu, Simulation.SIMULATE);
            eu = this.charge(player, eu);
            this.energy.consumeEu(eu, Simulation.ACT);
        }
    }

    public void writeNbt(CompoundTag tag) {
    }

    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
    }
}

