/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.craft.potion;

import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StorageView;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.swedz.extended_industrialization.machines.components.craft.potion.PotionRecipe;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.AbstractModularCrafterComponent;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccessBehavior;
import net.swedz.tesseract.neoforge.compat.mi.helper.MachineInventoryHelper;

public final class PotionCrafterComponent
extends AbstractModularCrafterComponent<PotionRecipe> {
    private final Params params;
    private int blazingEssence;
    private RollingRecipeFlags tryRollingRecipeFlags;

    public PotionCrafterComponent(Params params, MachineBlockEntity blockEntity, CrafterComponent.Inventory inventory, ModularCrafterAccessBehavior behavior) {
        super(blockEntity, inventory, behavior);
        this.params = params;
    }

    public long getBaseRecipeEu() {
        return ((PotionRecipe)this.activeRecipe).euCost();
    }

    public long getRecipeEuCost(PotionRecipe recipe) {
        return recipe.euCost();
    }

    public long getRecipeTotalEuCost(PotionRecipe recipe) {
        return recipe.totalEuCost();
    }

    protected boolean canContinueRecipe() {
        return true;
    }

    protected ResourceLocation getRecipeId(PotionRecipe recipe) {
        return recipe.id();
    }

    protected PotionRecipe getRecipeById(ResourceLocation resourceLocation) {
        return PotionRecipe.getRecipe(resourceLocation);
    }

    public boolean doConditionsMatchForRecipe(PotionRecipe recipe) {
        return true;
    }

    protected void onTick() {
        this.doBlazeEssenceStuff();
    }

    private void doBlazeEssenceStuff() {
        ConfigurableItemStack slotPowder = this.params.blazePowder().slot(this.inventory.getItemInputs());
        if (slotPowder.getAmount() == 0L) {
            return;
        }
        if (this.blazingEssence > 0) {
            return;
        }
        slotPowder.decrement(1L);
        this.blazingEssence = 20;
    }

    protected List<PotionRecipe> getRecipes() {
        if (this.efficiencyTicks > 0) {
            return List.of((PotionRecipe)this.activeRecipe);
        }
        return PotionRecipe.getRecipes();
    }

    protected boolean tryStartRecipe(PotionRecipe recipe) {
        this.tryRollingRecipeFlags = new RollingRecipeFlags();
        boolean success = super.tryStartRecipe((Object)recipe);
        this.tryRollingRecipeFlags = null;
        return success;
    }

    private ItemStack transform(ItemStack stack) {
        if (stack.is(Items.GLASS_BOTTLE)) {
            return PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)Potions.WATER);
        }
        return stack;
    }

    private List<StorageView<ItemVariant>> truncate(MIItemStorage storage) {
        ArrayList items = Lists.newArrayList((Iterator)storage.iterator());
        items.removeIf(item -> MachineInventoryHelper.isActuallyJustAir((ConfigurableItemStack)((ConfigurableItemStack)item)));
        return items;
    }

    protected boolean takeInputs(PotionRecipe recipe, boolean simulate) {
        return super.takeInputs((Object)recipe, simulate) && this.takeBlazingEssenceInputs(recipe, simulate);
    }

    protected boolean takeItemInputs(PotionRecipe recipe, boolean simulate) {
        MIItemStorage bottleStorage = new MIItemStorage(this.params.bottle().slots(this.inventory.getItemInputs()));
        MIItemStorage reagentStorage = new MIItemStorage(this.params.reagent().slots(this.inventory.getItemInputs()));
        List<StorageView<ItemVariant>> truncatedReagentItems = this.truncate(reagentStorage);
        List<PotionRecipe> subchain = recipe.subchain(truncatedReagentItems);
        if (subchain.isEmpty()) {
            return false;
        }
        try (Transaction transaction = Transaction.openOuter();){
            boolean usedBottles = this.takeBottleItemInputs(recipe, transaction, subchain);
            boolean usedReagents = this.takeReagentItemInputs(recipe, transaction, reagentStorage, truncatedReagentItems);
            if (!simulate) {
                transaction.commit();
            }
            boolean bl = usedBottles && usedReagents;
            return bl;
        }
    }

    private boolean takeBottleItemInputs(PotionRecipe recipe, Transaction transaction, List<PotionRecipe> subchain) {
        MIItemStorage bottleStorage = new MIItemStorage(this.params.bottle().slots(this.inventory.getItemInputs()));
        PotionRecipe startRecipe = subchain.get(0);
        for (StorageView item : bottleStorage) {
            ItemStack itemStack;
            if (item.isResourceBlank() || !ItemStack.isSameItemSameTags((ItemStack)this.transform(itemStack = ((ItemVariant)item.getResource()).toStack()), (ItemStack)startRecipe.input())) continue;
            Transaction nested = Transaction.openNested((TransactionContext)transaction);
            try {
                long count = 0L;
                for (StorageView otherItem : bottleStorage) {
                    long extracted;
                    ItemStack otherItemStack = ((ItemVariant)otherItem.getResource()).toStack();
                    if (!ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)otherItemStack) || (count += (extracted = bottleStorage.extractAllSlot((TransferVariant)((ItemVariant)otherItem.getResource()), (long)recipe.bottles() - count, (TransactionContext)nested))) != (long)recipe.bottles()) continue;
                    this.tryRollingRecipeFlags.needsWater = itemStack.is(Items.GLASS_BOTTLE);
                    nested.commit();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (nested == null) continue;
                nested.close();
            }
        }
        return false;
    }

    private boolean takeReagentItemInputs(PotionRecipe recipe, Transaction transaction, MIItemStorage reagentStorage, List<StorageView<ItemVariant>> truncatedReagentItems) {
        try (Transaction nested = Transaction.openNested((TransactionContext)transaction);){
            for (StorageView<ItemVariant> item : truncatedReagentItems) {
                long extracted = reagentStorage.extractAllSlot((TransferVariant)((ItemVariant)item.getResource()), 1L, (TransactionContext)nested);
                if (extracted == 1L) continue;
                boolean bl = false;
                return bl;
            }
            nested.commit();
            boolean bl = true;
            return bl;
        }
    }

    protected boolean takeFluidInputs(PotionRecipe recipe, boolean simulate) {
        return !this.tryRollingRecipeFlags.needsWater || recipe.water() == 0 || MachineInventoryHelper.consumeFluid((List)this.inventory.getFluidInputs(), (Fluid)Fluids.WATER, (long)recipe.water(), (boolean)simulate) == (long)recipe.water();
    }

    private boolean takeBlazingEssenceInputs(PotionRecipe recipe, boolean simulate) {
        if (this.blazingEssence < recipe.blazingEssence()) {
            return false;
        }
        if (!simulate) {
            this.blazingEssence -= recipe.blazingEssence();
        }
        return true;
    }

    protected boolean putItemOutputs(PotionRecipe recipe, boolean simulate, boolean toggleLock) {
        MIItemStorage outputStorage = new MIItemStorage(this.params.output().slots(this.inventory.getItemOutputs()));
        try (Transaction transaction = Transaction.openOuter();){
            long inserted = outputStorage.insertAllSlot((TransferVariant)ItemVariant.of((ItemStack)recipe.output()), (long)recipe.bottles(), (TransactionContext)transaction);
            if (inserted == (long)recipe.bottles()) {
                if (!simulate) {
                    transaction.commit();
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected boolean putFluidOutputs(PotionRecipe recipe, boolean simulate, boolean toggleLock) {
        return true;
    }

    public void writeNbt(CompoundTag tag) {
        super.writeNbt(tag);
        tag.putInt("blazingEssence", this.blazingEssence);
    }

    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        super.readNbt(tag, isUpgradingMachine);
        this.blazingEssence = tag.getInt("blazingEssence");
    }

    public void lockRecipe(ResourceLocation recipeId, Inventory inventory) {
    }

    public record Params(SlotRange<ConfigurableItemStack> blazePowder, SlotRange<ConfigurableItemStack> bottle, SlotRange<ConfigurableItemStack> reagent, SlotRange<ConfigurableItemStack> output, SlotRange<ConfigurableFluidStack> water) {
    }

    public record SlotRange<T extends AbstractConfigurableStack>(int start, int end) {
        public SlotRange(int slot) {
            this(slot, slot);
        }

        public static SlotRange<ConfigurableItemStack> item(int start, int end) {
            return new SlotRange<ConfigurableItemStack>(start, end);
        }

        public static SlotRange<ConfigurableItemStack> item(int slot) {
            return new SlotRange<ConfigurableItemStack>(slot);
        }

        public static SlotRange<ConfigurableFluidStack> fluid(int start, int end) {
            return new SlotRange<ConfigurableFluidStack>(start, end);
        }

        public static SlotRange<ConfigurableFluidStack> fluid(int slot) {
            return new SlotRange<ConfigurableFluidStack>(slot);
        }

        public List<T> slots(List<T> slots) {
            return slots.subList(this.start, this.end + 1);
        }

        public T slot(List<T> slots) {
            return (T)((AbstractConfigurableStack)this.slots(slots).get(0));
        }
    }

    private static final class RollingRecipeFlags {
        private boolean needsWater;

        private RollingRecipeFlags() {
        }
    }
}

