/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.craft.potion;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StorageView;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.BrewingRecipeRegistry;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.datamaps.PotionBrewingCosts;

public final class PotionRecipe {
    private final ResourceLocation id;
    private final ItemStack input;
    private final Ingredient reagent;
    private final ItemStack output;
    private final Potion potion;
    private PotionBrewingCosts costs;
    private List<PotionRecipe> chain;
    private static Map<ResourceLocation, PotionRecipe> RECIPE_MAP = Maps.newHashMap();
    private static List<PotionRecipe> RECIPES = Lists.newArrayList();

    public PotionRecipe(ResourceLocation id, ItemStack input, Ingredient reagent, ItemStack output, Potion potion) {
        this.id = id;
        this.input = input;
        this.reagent = reagent;
        this.output = output;
        this.potion = potion;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public ItemStack input() {
        return this.input;
    }

    public Ingredient reagent() {
        return this.reagent;
    }

    public ItemStack output() {
        return this.output;
    }

    public Potion potion() {
        return this.potion;
    }

    private PotionBrewingCosts costs() {
        if (this.costs == null) {
            this.costs = PotionBrewingCosts.getFor(this.potion);
        }
        return this.costs;
    }

    public int bottles() {
        return this.costs().bottles();
    }

    public int water() {
        return this.costs().water();
    }

    public int blazingEssence() {
        return this.costs().blazingEssence();
    }

    public int time() {
        return this.costs().time();
    }

    public int euCost() {
        return this.costs().euCost();
    }

    public int totalEuCost() {
        return this.costs().totalEuCost();
    }

    private List<PotionRecipe> generateChain(List<PotionRecipe> recipes) {
        recipes.add(0, this);
        for (PotionRecipe parent : PotionRecipe.getRecipes()) {
            if (!ItemStack.isSameItemSameTags((ItemStack)this.input, (ItemStack)parent.output)) continue;
            return parent.generateChain(recipes);
        }
        return recipes;
    }

    private List<PotionRecipe> generateChain() {
        return Collections.unmodifiableList(this.generateChain(Lists.newArrayList()));
    }

    public List<PotionRecipe> chain() {
        if (this.chain == null) {
            this.chain = this.generateChain();
        }
        return this.chain;
    }

    public List<PotionRecipe> subchain(List<StorageView<ItemVariant>> truncatedReagentItems) {
        if (this.chain().size() < truncatedReagentItems.size()) {
            return List.of();
        }
        int subchainStartIndex = this.chain().size() - truncatedReagentItems.size();
        int subchainEndIndex = this.chain().size();
        List<PotionRecipe> subchain = this.chain().subList(subchainStartIndex, subchainEndIndex);
        for (int reagentIndex = 0; reagentIndex < truncatedReagentItems.size(); ++reagentIndex) {
            StorageView<ItemVariant> reagent = truncatedReagentItems.get(reagentIndex);
            ItemStack reagentStack = ((ItemVariant)reagent.getResource()).toStack();
            PotionRecipe subrecipe = subchain.get(reagentIndex);
            if (subrecipe.reagent().test(reagentStack)) continue;
            return List.of();
        }
        return Collections.unmodifiableList(subchain);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PotionRecipe other = (PotionRecipe)obj;
        return ItemStack.isSameItemSameTags((ItemStack)this.input, (ItemStack)other.input) && Objects.equals(this.reagent, other.reagent) && ItemStack.isSameItemSameTags((ItemStack)this.output, (ItemStack)other.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.reagent, this.output);
    }

    private static String subId(ResourceLocation location) {
        return "%s/%s".formatted(location.getNamespace(), location.getPath());
    }

    private static String subId(Item item) {
        return PotionRecipe.subId(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    private static String subId(ItemStack stack) {
        return PotionRecipe.subId(stack.getItem());
    }

    private static String subId(Ingredient ingredient) {
        return PotionRecipe.subId(ingredient.getItems()[0]);
    }

    private static String subId(Potion potion) {
        return PotionRecipe.subId(BuiltInRegistries.POTION.getKey((Object)potion));
    }

    private static Map<ResourceLocation, PotionRecipe> fetchRecipes() {
        ResourceLocation id;
        String outputId;
        String inputId;
        String reagentId;
        HashMap recipes = Maps.newHashMap();
        for (Ingredient allowedContainer : PotionBrewing.ALLOWED_CONTAINERS) {
            for (ItemStack stack : allowedContainer.getItems()) {
                String stackId = PotionRecipe.subId(stack);
                for (PotionBrewing.Mix mix : PotionBrewing.POTION_MIXES) {
                    if (mix.ingredient.getItems().length == 0) continue;
                    reagentId = PotionRecipe.subId(mix.ingredient);
                    inputId = PotionRecipe.subId((Potion)mix.from);
                    outputId = PotionRecipe.subId((Potion)mix.to);
                    id = EI.id("brewing/container/%s/%s/%s/%s".formatted(stackId, reagentId, inputId, outputId));
                    if (recipes.containsKey(id)) {
                        throw new IllegalStateException("Generated duplicate potion recipe id %s".formatted(id));
                    }
                    recipes.put(id, new PotionRecipe(id, PotionUtils.setPotion((ItemStack)stack.copy(), (Potion)((Potion)mix.from)), mix.ingredient, PotionUtils.setPotion((ItemStack)stack.copy(), (Potion)((Potion)mix.to)), (Potion)mix.to));
                }
            }
        }
        for (PotionBrewing.Mix mix : PotionBrewing.CONTAINER_MIXES) {
            if (mix.ingredient.getItems().length == 0) continue;
            String reagentId2 = PotionRecipe.subId(mix.ingredient);
            String inputId2 = PotionRecipe.subId((Item)mix.from);
            String outputId2 = PotionRecipe.subId((Item)mix.to);
            Consumer<Holder> recipeGen = entry -> {
                Potion potion = (Potion)entry.value();
                if (potion == Potions.EMPTY || !PotionBrewing.isBrewablePotion((Potion)potion)) {
                    return;
                }
                ResourceLocation id = EI.id("brewing/item/%s/%s/%s/%s".formatted(PotionRecipe.subId(((ResourceKey)entry.unwrapKey().orElseThrow()).location()), reagentId2, inputId2, outputId2));
                if (recipes.containsKey(id)) {
                    throw new IllegalStateException("Generated duplicate potion recipe id %s".formatted(id));
                }
                recipes.put(id, new PotionRecipe(id, PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)mix.from), (Potion)potion), mix.ingredient, PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)mix.to), (Potion)potion), potion));
            };
            if (mix.from instanceof PotionItem) {
                BuiltInRegistries.POTION.holders().forEach(recipeGen);
                continue;
            }
            recipeGen.accept(BuiltInRegistries.POTION.wrapAsHolder((Object)Potions.AWKWARD));
        }
        for (IBrewingRecipe brewingRecipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(brewingRecipe instanceof BrewingRecipe)) continue;
            BrewingRecipe recipe = (BrewingRecipe)brewingRecipe;
            for (ItemStack stack : recipe.getInput().getItems()) {
                ItemStack output = recipe.getOutput(stack, recipe.getIngredient().getItems()[0]);
                Potion potion = PotionUtils.getPotion((ItemStack)output);
                if (potion == Potions.EMPTY) {
                    EI.LOGGER.warn("Found modded potion recipe with invalid potion output");
                    continue;
                }
                reagentId = PotionRecipe.subId(recipe.getIngredient());
                inputId = PotionRecipe.subId(stack);
                outputId = PotionRecipe.subId(output);
                id = EI.id("brewing/neoforge/%s/%s/%s".formatted(inputId, reagentId, outputId));
                if (recipes.containsKey(id)) {
                    throw new IllegalStateException("Generated duplicate potion recipe id %s".formatted(id));
                }
                recipes.put(id, new PotionRecipe(id, stack.copy(), recipe.getIngredient(), output, potion));
            }
        }
        return recipes;
    }

    public static List<PotionRecipe> getRecipes() {
        return RECIPES;
    }

    public static PotionRecipe getRecipe(ResourceLocation id) {
        return RECIPE_MAP.get(id);
    }

    public static void init() {
        RECIPE_MAP = PotionRecipe.fetchRecipes();
        RECIPES = Collections.unmodifiableList(Lists.newArrayList(RECIPE_MAP.values()));
        EI.LOGGER.info("Generated {} potion recipes with their chains successfully", (Object)PotionRecipe.getRecipes().size());
    }

    private static void printDebug() {
        Function<Potion, ResourceLocation> potionId = arg_0 -> ((DefaultedRegistry)BuiltInRegistries.POTION).getKey(arg_0);
        EI.LOGGER.info("Cached {} recipes into the potion recipe cache", (Object)PotionRecipe.getRecipes().size());
        for (PotionRecipe recipe : PotionRecipe.getRecipes()) {
            EI.LOGGER.info("- {}: input=({}), reagent=({}), output=({}), chain={}", new Object[]{potionId.apply(recipe.potion()), potionId.apply(PotionUtils.getPotion((ItemStack)recipe.input())), recipe.reagent().getItems()[0], potionId.apply(PotionUtils.getPotion((ItemStack)recipe.output())), recipe.chain().size()});
        }
    }
}

