/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.craft.processingarray;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.DropableComponent;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.guicomponents.processingarraymachineslot.ProcessingArrayMachineSlot;

public final class ProcessingArrayMachineComponent
implements IComponent.ServerOnly,
DropableComponent {
    public static final ResourceLocation ID = EI.id("processing_array_machine");
    private ItemStack machines = ItemStack.EMPTY;
    private MachineRecipeType machineRecipeType;

    public ItemStack getMachines() {
        return this.machines;
    }

    public boolean hasMachines() {
        return !this.machines.isEmpty() && this.machineRecipeType != null;
    }

    public int getMachineCount() {
        return this.machines.getCount();
    }

    public MachineRecipeType getMachineRecipeType() {
        return this.machineRecipeType;
    }

    public void setMachines(MachineBlockEntity be, ItemStack machines) {
        this.machines = machines;
        this.machineRecipeType = machines.isEmpty() ? null : ProcessingArrayMachineSlot.getMachine(machines).recipeType();
        be.setChanged();
        be.sync();
    }

    public void writeNbt(CompoundTag tag) {
        tag.put("machinesStack", (Tag)this.machines.save(new CompoundTag()));
    }

    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        this.machines = ItemStack.of((CompoundTag)tag.getCompound("machinesStack"));
        if (!this.machines.isEmpty()) {
            this.machineRecipeType = ProcessingArrayMachineSlot.getMachine(this.machines).recipeType();
        }
    }

    public ItemStack getDrop() {
        return this.machines;
    }
}

