/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.farmer;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.swedz.extended_industrialization.EILocalizedListeners;
import net.swedz.extended_industrialization.machines.components.farmer.FarmerComponentPlantableStacks;
import net.swedz.extended_industrialization.machines.components.farmer.PlantingMode;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerBlockMap;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.HarvestingHandler;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.registry.FarmerHarvestingHandlers;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.registry.FarmerHarvestingHandlersHolder;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.registry.FarmerListener;
import net.swedz.extended_industrialization.machines.components.farmer.task.FarmerProcessRates;
import net.swedz.extended_industrialization.machines.components.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.components.farmer.task.FarmerTaskType;
import net.swedz.tesseract.neoforge.compat.mi.helper.MachineInventoryHelper;
import net.swedz.tesseract.neoforge.event.FarmlandLoseMoistureEvent;

public final class FarmerComponent
implements IComponent {
    private final MultiblockInventoryComponent inventory;
    private final IsActiveComponent isActive;
    private final FarmerComponentPlantableStacks plantableStacks;
    private final PlantingMode defaultPlantingMode;
    private final FarmerProcessRates processRates;
    private final FarmerBlockMap blockMap;
    private final FarmerHarvestingHandlersHolder harvestingHandlers;
    private final List<FarmerTask> tasks;
    private final List<FarmerListener<? extends Event>> listeners = Lists.newArrayList();
    public PlantingMode plantingMode;
    public boolean tilling;
    private Level level;
    private ShapeMatcher shapeMatcher;
    private int processTick;

    public FarmerComponent(MultiblockInventoryComponent inventory, IsActiveComponent isActive, PlantingMode defaultPlantingMode, FarmerProcessRates processRates) {
        this.inventory = inventory;
        this.isActive = isActive;
        this.plantableStacks = new FarmerComponentPlantableStacks(this);
        this.defaultPlantingMode = defaultPlantingMode;
        this.plantingMode = defaultPlantingMode;
        this.processRates = processRates;
        this.blockMap = new FarmerBlockMap();
        this.harvestingHandlers = FarmerHarvestingHandlers.create();
        this.tasks = Stream.of(FarmerTaskType.values()).filter(processRates::contains).map(task -> task.create(this)).toList();
        this.listeners.add(new FarmerListener<BlockEvent.FarmlandTrampleEvent>(BlockEvent.FarmlandTrampleEvent.class, event -> {
            if (this.tilling && this.blockMap.containsDirtAt(event.getPos())) {
                event.setCanceled(true);
            }
        }));
        this.listeners.add(new FarmerListener<FarmlandLoseMoistureEvent>(FarmlandLoseMoistureEvent.class, event -> {
            if (this.tilling && this.blockMap.containsDirtAt(event.getPos()) && FarmerComponent.consumeWater(inventory, Simulation.SIMULATE)) {
                FarmerComponent.consumeWater(inventory, Simulation.ACT);
                event.setCanceled(true);
            }
        }));
        this.listeners.addAll(this.harvestingHandlers.getListeners(this.blockMap));
    }

    public MultiblockInventoryComponent getInventory() {
        return this.inventory;
    }

    public FarmerBlockMap getBlockMap() {
        return this.blockMap;
    }

    public FarmerHarvestingHandlersHolder getHarvestingHandlersHolder() {
        return this.harvestingHandlers;
    }

    public FarmerComponentPlantableStacks getPlantableStacks() {
        return this.plantableStacks;
    }

    public FarmerProcessRates getProcessRates() {
        return this.processRates;
    }

    public static boolean consumeWater(MultiblockInventoryComponent inventory, Simulation simulation) {
        return MachineInventoryHelper.consumeFluid((List)inventory.getFluidInputs(), (Fluid)Fluids.WATER, (long)50L, (Simulation)simulation) == 50L;
    }

    public void fromOffsets(BlockPos controllerPos, Direction controllerDirection, List<BlockPos> offsets) {
        this.blockMap.fromOffsets(this.level, controllerPos, controllerDirection, offsets);
    }

    public void updateStackListeners() {
        this.plantableStacks.update(this.inventory.getItemInputs());
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        ++this.processTick;
        this.blockMap.markDirty();
        boolean hasWater = FarmerComponent.consumeWater(this.inventory, Simulation.SIMULATE);
        for (FarmerTask task : this.tasks) {
            task.run(this.level, this.plantingMode, this.tilling, this.processTick, hasWater);
        }
        if (this.processTick >= 1200) {
            this.processTick = 0;
        }
    }

    public void registerListeners(Level level, ShapeMatcher shapeMatcher) {
        if (this.shapeMatcher != null) {
            throw new IllegalStateException("There are already listeners registered on this FarmerComponent");
        }
        this.level = level;
        this.shapeMatcher = shapeMatcher;
        for (FarmerListener<? extends Event> listener : this.listeners) {
            EILocalizedListeners.INSTANCE.register(level, shapeMatcher.getSpannedChunks(), listener.eventClass(), listener.listener());
        }
    }

    public void unregisterListeners(Level level, ShapeMatcher shapeMatcher) {
        for (FarmerListener<? extends Event> listener : this.listeners) {
            EILocalizedListeners.INSTANCE.unregister(level, shapeMatcher.getSpannedChunks(), listener.eventClass(), listener.listener());
        }
        this.shapeMatcher = null;
    }

    public void writeNbt(CompoundTag tag) {
        tag.putBoolean("tilling", this.tilling);
        tag.putString("planting_mode", this.plantingMode.name());
        CompoundTag harvestingHandlersCache = new CompoundTag();
        for (HarvestingHandler harvestingHandler : this.harvestingHandlers.getHandlers()) {
            harvestingHandler.writeNbt(harvestingHandlersCache);
        }
        tag.put("harvesting_handlers", (Tag)harvestingHandlersCache);
        CompoundTag tasksTag = new CompoundTag();
        for (FarmerTask task : this.tasks) {
            CompoundTag taskTag = new CompoundTag();
            task.writeNbt(taskTag);
            if (taskTag.isEmpty()) continue;
            tasksTag.put(task.type().name(), (Tag)taskTag);
        }
        if (!tasksTag.isEmpty()) {
            tag.put("tasks", (Tag)tasksTag);
        }
    }

    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        this.tilling = tag.getBoolean("tilling");
        this.plantingMode = PlantingMode.fromName(tag.getString("planting_mode"));
        if (this.plantingMode == null) {
            this.plantingMode = this.defaultPlantingMode;
        }
        CompoundTag harvestingHandlersCache = tag.getCompound("harvesting_handlers");
        for (HarvestingHandler harvestingHandler : this.harvestingHandlers.getHandlers()) {
            harvestingHandler.readNbt(harvestingHandlersCache);
        }
        CompoundTag tasksTag = tag.getCompound("tasks");
        if (!tasksTag.isEmpty()) {
            for (FarmerTask task : this.tasks) {
                CompoundTag taskTag = tasksTag.getCompound(task.type().name());
                task.readNbt(taskTag, isUpgradingMachine);
            }
        }
    }
}

