/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.farmer;

import aztech.modern_industrialization.inventory.ChangeListener;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.IPlantable;

public final class PlantableConfigurableItemStack
extends ChangeListener {
    private final ConfigurableItemStack stack;
    private Item lastUpdateItem;
    private boolean plantable;

    PlantableConfigurableItemStack(ConfigurableItemStack stack) {
        this.stack = stack;
    }

    public ConfigurableItemStack getStack() {
        return this.stack;
    }

    public ItemVariant getItemVariant() {
        return (this.stack.isPlayerLocked() || this.stack.isMachineLocked()) && ((ItemVariant)this.stack.getResource()).isBlank() ? ItemVariant.of((ItemLike)((ItemLike)this.stack.getLockedInstance())) : (ItemVariant)this.stack.getResource();
    }

    public Item getItem() {
        return this.getItemVariant().getItem();
    }

    public boolean isPlantable() {
        return this.plantable;
    }

    public IPlantable asPlantable() {
        if (!this.plantable) {
            throw new IllegalStateException("Tried to get plantable of non-plantable stack");
        }
        return (IPlantable)((BlockItem)this.getItem()).getBlock();
    }

    public BlockState getPlant(Level level, BlockPos pos) {
        return this.asPlantable().getPlant((BlockGetter)level, pos);
    }

    protected void onChange() {
        ItemVariant itemVariant = this.getItemVariant();
        Item item = itemVariant.getItem();
        if (this.lastUpdateItem != item) {
            BlockItem blockItem;
            this.plantable = item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof IPlantable;
        }
        this.lastUpdateItem = item;
    }

    protected boolean isValid(Object token) {
        return true;
    }
}

