/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.farmer.block;

import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerBlock;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerTile;

public final class FarmerBlockMap
implements Iterable<FarmerTile> {
    private List<FarmerTile> tiles = List.of();
    private List<BlockPos> dirtPositions = List.of();

    public List<FarmerTile> tiles() {
        return this.tiles;
    }

    @Override
    public Iterator<FarmerTile> iterator() {
        return this.tiles.iterator();
    }

    public boolean containsDirtAt(BlockPos pos) {
        return this.dirtPositions.contains(pos);
    }

    public void fromOffsets(Level level, BlockPos controllerPos, Direction controllerDirection, List<BlockPos> offsets) {
        BlockPos centerPos = controllerPos.relative(controllerDirection.getOpposite());
        ArrayList<FarmerTile> tiles = new ArrayList<FarmerTile>(offsets.size());
        ArrayList<BlockPos> dirtPositions = new ArrayList<BlockPos>(offsets.size());
        int minX = offsets.stream().mapToInt(Vec3i::getX).min().orElseThrow();
        for (BlockPos offset : offsets) {
            int quadrant;
            BlockPos dirtPos = ShapeMatcher.toWorldPos((BlockPos)controllerPos, (Direction)controllerDirection, (BlockPos)offset);
            BlockPos cropPos = dirtPos.above();
            int line = Math.abs(dirtPos.getX() - minX);
            if (dirtPos.getX() > centerPos.getX() && dirtPos.getZ() <= centerPos.getZ()) {
                quadrant = 0;
            } else if (dirtPos.getX() >= centerPos.getX() && dirtPos.getZ() > centerPos.getZ()) {
                quadrant = 1;
            } else if (dirtPos.getX() < centerPos.getX() && dirtPos.getZ() >= centerPos.getZ()) {
                quadrant = 2;
            } else if (dirtPos.getX() <= centerPos.getX() && dirtPos.getZ() < centerPos.getZ()) {
                quadrant = 3;
            } else {
                throw new IllegalStateException("Somehow a position was not in a quadrant");
            }
            FarmerBlock dirt = new FarmerBlock(dirtPos);
            dirt.updateState(level);
            FarmerBlock crop = new FarmerBlock(cropPos);
            crop.updateState(level);
            tiles.add(new FarmerTile(dirt, crop, line, quadrant));
            dirtPositions.add(dirtPos);
        }
        this.tiles = Collections.unmodifiableList(tiles);
        this.dirtPositions = Collections.unmodifiableList(dirtPositions);
    }

    public void markDirty() {
        for (FarmerTile tile : this.tiles) {
            tile.dirt().markDirty();
            tile.crop().markDirty();
        }
    }
}

