/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.HarvestingContext;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.HarvestingHandler;

public interface LootTableHarvestingHandler
extends HarvestingHandler {
    default public LootTable getLootTable(HarvestingContext context) {
        ResourceLocation lootTableId = context.state().getBlock().getLootTable();
        return context.level().getServer().getLootData().getLootTable(lootTableId);
    }

    @Override
    default public List<ItemStack> getDrops(HarvestingContext context) {
        List<BlockPos> blocks = this.getBlocks(context);
        ArrayList drops = Lists.newArrayList();
        for (BlockPos block : blocks) {
            HarvestingContext blockContext = new HarvestingContext(context.level(), block, context.level().getBlockState(block));
            LootTable lootTable = this.getLootTable(blockContext);
            LootParams lootParams = new LootParams.Builder((ServerLevel)context.level()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)block)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.BLOCK_STATE, (Object)blockContext.state()).create(LootContextParamSets.BLOCK);
            drops.addAll(lootTable.getRandomItems(lootParams));
        }
        return drops;
    }
}

