/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.handlers;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.bus.api.Event;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerBlockMap;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerTree;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.HarvestingContext;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.LootTableHarvestingHandler;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.registry.FarmerListener;
import net.swedz.tesseract.neoforge.event.TreeGrowthEvent;

public final class TreeBlockHarvestHandler
implements LootTableHarvestingHandler {
    private final Map<BlockPos, FarmerTree> trees = Maps.newHashMap();

    @Override
    public boolean matches(HarvestingContext context) {
        return this.trees.containsKey(context.pos());
    }

    @Override
    public boolean isFullyGrown(HarvestingContext context) {
        return true;
    }

    @Override
    public List<BlockPos> getBlocks(HarvestingContext context) {
        return this.trees.get(context.pos()).blocks();
    }

    @Override
    public void harvested(HarvestingContext context) {
        this.trees.remove(context.pos());
    }

    @Override
    public List<FarmerListener<? extends Event>> getListeners(FarmerBlockMap farmerBlockMap) {
        return List.of(new FarmerListener<TreeGrowthEvent>(TreeGrowthEvent.class, event -> {
            BlockPos base = event.getPos();
            if (farmerBlockMap.containsDirtAt(base.below())) {
                List blocks = event.getPositions();
                blocks.removeIf(farmerBlockMap::containsDirtAt);
                blocks.sort(Collections.reverseOrder(Comparator.comparingInt(Vec3i::getY)));
                this.trees.put(base, new FarmerTree(base, blocks));
            }
        }));
    }

    @Override
    public void writeNbt(CompoundTag tag) {
        CompoundTag trees = new CompoundTag();
        for (FarmerTree tree : this.trees.values()) {
            long[] list = tree.blocks().stream().mapToLong(BlockPos::asLong).toArray();
            trees.putLongArray(Long.toString(tree.base().asLong()), list);
        }
        tag.put("trees", (Tag)trees);
    }

    @Override
    public void readNbt(CompoundTag tag) {
        CompoundTag trees = tag.getCompound("trees");
        for (String key : trees.getAllKeys()) {
            BlockPos base = BlockPos.of((long)Long.parseLong(key));
            List<BlockPos> blocks = Arrays.stream(trees.getLongArray(key)).mapToObj(BlockPos::of).toList();
            this.trees.put(base, new FarmerTree(base, blocks));
        }
    }
}

