/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.registry;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.HarvestingHandler;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.handlers.CropBlockHarvestHandler;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.handlers.SimpleTallCropHarvestHandler;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.handlers.TreeBlockHarvestHandler;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.registry.FarmerHarvestingHandlersHolder;

public final class FarmerHarvestingHandlers {
    private static final List<Supplier<HarvestingHandler>> HANDLERS = Lists.newArrayList();

    public static void register(Supplier<HarvestingHandler> handler) {
        HANDLERS.add(handler);
    }

    public static FarmerHarvestingHandlersHolder create() {
        return new FarmerHarvestingHandlersHolder(HANDLERS.stream().map(Supplier::get).toList());
    }

    static {
        FarmerHarvestingHandlers.register(CropBlockHarvestHandler::new);
        FarmerHarvestingHandlers.register(SimpleTallCropHarvestHandler::new);
        FarmerHarvestingHandlers.register(TreeBlockHarvestHandler::new);
    }
}

