/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.registry;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.neoforged.bus.api.Event;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerBlockMap;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.HarvestingContext;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.HarvestingHandler;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.registry.FarmerListener;

public final class FarmerHarvestingHandlersHolder {
    private final List<HarvestingHandler> handlers;

    FarmerHarvestingHandlersHolder(List<HarvestingHandler> handlers) {
        this.handlers = handlers;
    }

    public List<HarvestingHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public Optional<HarvestingHandler> getHandler(HarvestingContext context) {
        return this.handlers.stream().filter(handler -> handler.matches(context)).findFirst();
    }

    public List<FarmerListener<? extends Event>> getListeners(FarmerBlockMap farmerBlockMap) {
        return this.handlers.stream().flatMap(h -> h.getListeners(farmerBlockMap).stream()).toList();
    }
}

