/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.farmer.task.tasks;

import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.swedz.extended_industrialization.machines.components.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerBlock;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerTile;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.HarvestingContext;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.HarvestingHandler;
import net.swedz.extended_industrialization.machines.components.farmer.harvestinghandler.registry.FarmerHarvestingHandlersHolder;
import net.swedz.extended_industrialization.machines.components.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.components.farmer.task.FarmerTaskType;

public final class HarvestingFarmerTask
extends FarmerTask {
    private final FarmerHarvestingHandlersHolder harvestingHandlersHolder;

    public HarvestingFarmerTask(FarmerComponent component) {
        super(FarmerTaskType.HARVESTING, component);
        this.harvestingHandlersHolder = component.getHarvestingHandlersHolder();
    }

    private boolean harvestBlocks(FarmerBlock cropBlockEntry, HarvestingContext context, HarvestingHandler handler) {
        List<BlockPos> blockPositions = handler.getBlocks(context);
        if (blockPositions.size() == 0) {
            return false;
        }
        try (Transaction transaction = Transaction.openOuter();){
            List<ItemStack> items = handler.getDrops(context);
            if (items.size() == 0) {
                boolean bl = false;
                return bl;
            }
            MIItemStorage itemOutput = new MIItemStorage(this.inventory.getItemOutputs());
            boolean success = true;
            for (ItemStack item : items) {
                long inserted = itemOutput.insertAllSlot((TransferVariant)ItemVariant.of((ItemStack)item), (long)item.getCount(), (TransactionContext)transaction);
                if (inserted == (long)item.getCount()) continue;
                success = false;
                break;
            }
            if (!success) {
                boolean bl = false;
                return bl;
            }
            BlockState newState = Blocks.AIR.defaultBlockState();
            int i = 0;
            for (BlockPos blockPosition : blockPositions) {
                this.level.setBlock(blockPosition, newState, 3);
                this.level.gameEvent(GameEvent.BLOCK_DESTROY, blockPosition, GameEvent.Context.of((BlockState)this.level.getBlockState(blockPosition)));
                ++i;
            }
            cropBlockEntry.updateState(newState);
            transaction.commit();
            handler.harvested(context);
        }
        return true;
    }

    @Override
    protected boolean run() {
        for (FarmerTile tile : this.blockMap) {
            HarvestingHandler handler;
            BlockState state;
            FarmerBlock crop = tile.crop();
            BlockPos pos = crop.pos();
            HarvestingContext context = new HarvestingContext(this.level, pos, state = crop.state(this.level));
            Optional<HarvestingHandler> handlerOptional = this.harvestingHandlersHolder.getHandler(context);
            if (!handlerOptional.isPresent() || !(handler = handlerOptional.get()).isFullyGrown(context) || !this.harvestBlocks(crop, context, handler) || !this.operations.operate()) continue;
            return true;
        }
        return this.operations.didOperate();
    }
}

