/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.farmer.task.tasks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.swedz.extended_industrialization.machines.components.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.components.farmer.PlantableConfigurableItemStack;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerBlock;
import net.swedz.extended_industrialization.machines.components.farmer.block.FarmerTile;
import net.swedz.extended_industrialization.machines.components.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.components.farmer.task.FarmerTaskType;

public final class PlantingFarmerTask
extends FarmerTask {
    public PlantingFarmerTask(FarmerComponent component) {
        super(FarmerTaskType.PLANTING, component);
    }

    @Override
    protected boolean run() {
        List<PlantableConfigurableItemStack> plantables = this.plantableStacks.getItems();
        plantables.removeIf(plantable -> !plantable.isPlantable() || !this.plantingMode.includeEmptyStacks() && plantable.getStack().isEmpty());
        if (plantables.size() == 0) {
            return false;
        }
        for (FarmerTile tile : this.blockMap) {
            BlockState plantState;
            FarmerBlock crop = tile.crop();
            int index = this.plantingMode.index(tile, plantables);
            PlantableConfigurableItemStack plantable2 = plantables.get(index);
            if (!tile.canBePlantedOnBy(this.level, plantable2.asPlantable()) || plantable2.getStack().isEmpty()) continue;
            BlockPos pos = crop.pos();
            BlockState state = crop.state(this.level);
            if (!state.isAir() || !(plantState = plantable2.getPlant(this.level, pos)).canSurvive((LevelReader)this.level, pos)) continue;
            plantable2.getStack().decrement(1L);
            crop.setBlock(this.level, plantState, 3, GameEvent.BLOCK_PLACE, plantState);
            if (!this.operations.operate()) continue;
            return true;
        }
        return this.operations.didOperate();
    }
}

