/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.fluidharvesting;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.util.Simulation;
import java.util.List;
import net.swedz.tesseract.neoforge.compat.mi.helper.EuConsumerBehavior;

public abstract class FluidHarvestingBehavior {
    protected final MachineBlockEntity machine;
    protected final EuConsumerBehavior euBehavior;
    protected final int totalPumpingTicks;
    protected final float outputMultiplier;

    protected FluidHarvestingBehavior(MachineBlockEntity machine, EuConsumerBehavior euBehavior, int totalPumpingTicks, float outputMultiplier) {
        this.machine = machine;
        this.euBehavior = euBehavior;
        this.totalPumpingTicks = totalPumpingTicks;
        this.outputMultiplier = outputMultiplier;
    }

    public MachineBlockEntity getMachineBlockEntity() {
        return this.machine;
    }

    public ConfigurableFluidStack getMachineBlockFluidStack() {
        List fluidStacks = this.getMachineBlockEntity().getInventory().getFluidStacks();
        return (ConfigurableFluidStack)fluidStacks.get(fluidStacks.size() - 1);
    }

    public int totalPumpingTicks() {
        return this.totalPumpingTicks;
    }

    public long consumeEu(long max) {
        return this.euBehavior.consumeEu(max, Simulation.ACT);
    }

    public float getOutputMultiplier() {
        return this.outputMultiplier;
    }

    public abstract boolean canOperate();

    public abstract void operate();
}

