/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.fluidharvesting.honeyextractor;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.machines.components.fluidharvesting.FluidHarvestingBehavior;
import net.swedz.extended_industrialization.machines.components.fluidharvesting.FluidHarvestingBehaviorCreator;
import net.swedz.tesseract.neoforge.compat.mi.helper.EuConsumerBehavior;

public final class HoneyExtractorBehavior
extends FluidHarvestingBehavior {
    public static final FluidHarvestingBehaviorCreator STEEL = (m, e) -> new HoneyExtractorBehavior(m, e, 100, 1.0f);
    public static final FluidHarvestingBehaviorCreator ELECTRIC = (m, e) -> new HoneyExtractorBehavior(m, e, 100, 2.0f);
    private BeehiveBlockEntity hive;

    private HoneyExtractorBehavior(MachineBlockEntity machine, EuConsumerBehavior euBehavior, int totalPumpingTicks, float outputMultiplier) {
        super(machine, euBehavior, totalPumpingTicks, outputMultiplier);
    }

    @Override
    public boolean canOperate() {
        Optional<BeehiveBlockEntity> optionalHive = this.getHive();
        if (optionalHive.isEmpty()) {
            return false;
        }
        this.hive = optionalHive.get();
        return true;
    }

    @Override
    public void operate() {
        if (this.hive == null) {
            throw new IllegalStateException("Called operate with no hive found");
        }
        MachineBlockEntity machine = this.getMachineBlockEntity();
        BlockState hiveBlockState = this.hive.getBlockState();
        int honeyLevel = (Integer)hiveBlockState.getValue((Property)BeehiveBlock.HONEY_LEVEL);
        if (honeyLevel > 0) {
            ConfigurableFluidStack fluidStack = this.getMachineBlockFluidStack();
            machine.getLevel().setBlock(this.hive.getBlockPos(), (BlockState)hiveBlockState.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(honeyLevel - 1)), 3);
            long honeyToCollect = Math.min((long)this.getOutputMultiplier() * 1000L / 5L, fluidStack.getRemainingSpace());
            fluidStack.setKey((TransferVariant)FluidVariant.of((Fluid)EIFluids.HONEY.asFluid()));
            fluidStack.increment(honeyToCollect);
        }
    }

    private Optional<BeehiveBlockEntity> getHive() {
        Optional<BeehiveBlockEntity> optional;
        MachineBlockEntity machine = this.getMachineBlockEntity();
        BlockPos touchingBlockPos = machine.getBlockPos().relative(machine.orientation.facingDirection);
        BlockEntity touchingBlockEntity = machine.getLevel().getBlockEntity(touchingBlockPos);
        if (touchingBlockEntity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity beehive = (BeehiveBlockEntity)touchingBlockEntity;
            optional = Optional.of(beehive);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

