/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.fluidharvesting.wastecollector;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.machines.components.fluidharvesting.FluidHarvestingBehavior;
import net.swedz.extended_industrialization.machines.components.fluidharvesting.FluidHarvestingBehaviorCreator;
import net.swedz.tesseract.neoforge.compat.mi.helper.EuConsumerBehavior;

public final class WasteCollectorBehavior
extends FluidHarvestingBehavior {
    public static final FluidHarvestingBehaviorCreator BRONZE = (m, e) -> new WasteCollectorBehavior(m, e, 300, 1.0f, 0);
    public static final FluidHarvestingBehaviorCreator STEEL = (m, e) -> new WasteCollectorBehavior(m, e, 300, 2.0f, 0);
    public static final FluidHarvestingBehaviorCreator ELECTRIC = (m, e) -> new WasteCollectorBehavior(m, e, 300, 4.0f, 0);
    private static final int MAX_ANIMALS = 1;
    private static final int MANURE_PER_ANIMAL = 500;
    private final int range;
    private int animalsFound;

    private WasteCollectorBehavior(MachineBlockEntity machine, EuConsumerBehavior euBehavior, int totalPumpingTicks, float outputMultiplier, int range) {
        super(machine, euBehavior, totalPumpingTicks, outputMultiplier);
        this.range = range;
    }

    @Override
    public boolean canOperate() {
        this.animalsFound = Math.min(this.countAnimalsInArea(), 1);
        return this.animalsFound > 0;
    }

    @Override
    public void operate() {
        if (this.animalsFound == 0) {
            throw new IllegalStateException("Called operate with no animals found");
        }
        ConfigurableFluidStack fluidStack = this.getMachineBlockFluidStack();
        long manureToCollect = Math.min((long)this.getOutputMultiplier() * 500L * (long)this.animalsFound, fluidStack.getRemainingSpace());
        fluidStack.setKey((TransferVariant)FluidVariant.of((Fluid)EIFluids.MANURE.asFluid()));
        fluidStack.increment(manureToCollect);
    }

    private int countAnimalsInArea() {
        BoundingBox bounds = new BoundingBox(this.getMachineBlockEntity().getBlockPos());
        bounds = new BoundingBox(bounds.minX() - this.range, bounds.minY() + 1, bounds.minZ() - this.range, bounds.maxX() + this.range, bounds.maxY() + 3, bounds.maxZ() + this.range);
        return this.getMachineBlockEntity().getLevel().getEntitiesOfClass(Animal.class, AABB.of((BoundingBox)bounds)).size();
    }
}

