/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.solar;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;

public final class SolarSunlightComponent
implements IComponent.ServerOnly {
    private final MachineBlockEntity machine;

    public SolarSunlightComponent(MachineBlockEntity machine) {
        this.machine = machine;
    }

    public long getTime() {
        return this.machine.getLevel().getDayTime() % 24000L;
    }

    public boolean isSolarTime() {
        long time = this.getTime();
        return time >= 0L && time <= 12000L;
    }

    public float getSolarEfficiency() {
        if (!this.canOperate()) {
            return 0.0f;
        }
        long time = this.getTime();
        if (time >= 4000L && time <= 8000L) {
            return 1.0f;
        }
        if (time < 4000L) {
            return -6.25E-8f * (float)time * (float)time + 5.0E-4f * (float)time;
        }
        if (time > 8000L) {
            return -6.25E-8f * (float)time * (float)time + 0.001f * (float)time - 3.0f;
        }
        throw new IllegalStateException();
    }

    public boolean hasSunlight() {
        Level level = this.machine.getLevel();
        return !level.isRaining() && !level.isThundering() && level.canSeeSky(this.machine.getBlockPos().above());
    }

    public boolean canOperate() {
        return this.isSolarTime() && this.hasSunlight();
    }

    public void writeNbt(CompoundTag tag) {
    }

    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
    }
}

