/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.components.solar.boiler;

import aztech.modern_industrialization.machines.IComponent;
import net.minecraft.nbt.CompoundTag;

public final class SolarBoilerCalcificationComponent
implements IComponent.ServerOnly {
    public static final long START_AFTER_TICKS = 216000L;
    public static final long CALCIFICATION_DURATION = 216000L;
    public static final float MINIMUM_EFFICIENCY = 0.33f;
    private long ticks;

    public void tick() {
        this.ticks = Math.min(++this.ticks, 432000L);
    }

    public float getCalcification() {
        if (this.ticks <= 216000L) {
            return 0.0f;
        }
        long calcificationTicks = this.ticks - 216000L;
        return (float)calcificationTicks / 216000.0f;
    }

    public float getEfficiency() {
        if (this.ticks <= 216000L) {
            return 1.0f;
        }
        float ratio = 1.0f - this.getCalcification();
        float efficiencyRange = 0.66999996f;
        return 0.33f + efficiencyRange * ratio;
    }

    public void writeNbt(CompoundTag tag) {
        tag.putLong("calcification_ticks", this.ticks);
    }

    public void readNbt(CompoundTag tag, boolean isUpgradingMachine) {
        this.ticks = tag.getLong("calcification_ticks");
    }
}

