/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponents.solarefficiency;

import aztech.modern_industrialization.machines.gui.GuiComponent;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.swedz.extended_industrialization.EI;

public final class SolarEfficiencyBar {
    public static final ResourceLocation ID = EI.id("solar_efficiency_bar");

    public record Parameters(int renderX, int renderY) {
    }

    private record Data(boolean working, int efficiency, int calcification, long energyProduced) {
    }

    public static final class Server
    implements GuiComponent.Server<Data> {
        private final Parameters params;
        private final Supplier<Boolean> workingSupplier;
        private final Supplier<Integer> efficiencySupplier;
        private final Supplier<Integer> calcificationSupplier;
        private final Supplier<Long> energyProducedSupplier;

        private Server(Parameters params, Supplier<Boolean> workingSupplier, Supplier<Integer> efficiencySupplier, Supplier<Integer> calcificationSupplier, Supplier<Long> energyProducedSupplier) {
            this.params = params;
            this.workingSupplier = workingSupplier;
            this.efficiencySupplier = efficiencySupplier;
            this.calcificationSupplier = calcificationSupplier;
            this.energyProducedSupplier = energyProducedSupplier;
        }

        public static Server calcification(Parameters params, Supplier<Boolean> workingSupplier, Supplier<Integer> efficiencySupplier, Supplier<Integer> calcificationSupplier) {
            return new Server(params, workingSupplier, efficiencySupplier, calcificationSupplier, () -> -1L);
        }

        public static Server energyProduced(Parameters params, Supplier<Boolean> workingSupplier, Supplier<Integer> efficiencySupplier, Supplier<Long> energyProducedSupplier) {
            return new Server(params, workingSupplier, efficiencySupplier, () -> -1, energyProducedSupplier);
        }

        public Data copyData() {
            return new Data(this.workingSupplier.get(), this.efficiencySupplier.get(), this.calcificationSupplier.get(), this.energyProducedSupplier.get());
        }

        public boolean needsSync(Data cachedData) {
            return !cachedData.equals(this.copyData());
        }

        public void writeInitialData(FriendlyByteBuf buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            this.writeCurrentData(buf);
        }

        public void writeCurrentData(FriendlyByteBuf buf) {
            long energyProduced;
            buf.writeBoolean(this.workingSupplier.get().booleanValue());
            buf.writeInt(this.efficiencySupplier.get().intValue());
            int calcification = this.calcificationSupplier.get();
            boolean hasCalcification = calcification >= 0;
            buf.writeBoolean(hasCalcification);
            if (hasCalcification) {
                buf.writeInt(calcification);
            }
            boolean hasEnergyProduced = (energyProduced = this.energyProducedSupplier.get().longValue()) >= 0L;
            buf.writeBoolean(hasEnergyProduced);
            if (hasEnergyProduced) {
                buf.writeLong(energyProduced);
            }
        }

        public ResourceLocation getId() {
            return ID;
        }
    }
}

