/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponents.universaltransformer;

import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.components.TransformerTierComponent;

public final class UniversalTransformerSlots {
    public static final ResourceLocation ID = EI.id("universal_transformer");

    public static int getSlotX() {
        return -22;
    }

    public static int getSlotY(int index) {
        return 19 + index * 36;
    }

    public static final class Server
    implements GuiComponent.ServerNoData {
        private final MachineBlockEntity machine;
        private final TransformerTierComponent transformerFrom;
        private final TransformerTierComponent transformerTo;

        public Server(MachineBlockEntity machine, TransformerTierComponent transformerFrom, TransformerTierComponent transformerTo) {
            this.machine = machine;
            this.transformerFrom = transformerFrom;
            this.transformerTo = transformerTo;
        }

        public void writeInitialData(FriendlyByteBuf buf) {
        }

        public ResourceLocation getId() {
            return ID;
        }

        private void addSlot(GuiComponent.MenuFacade menu, int index, final Supplier<ItemStack> getStack, final Consumer<ItemStack> setStack) {
            menu.addSlotToMenu((Slot)new HackySlot(UniversalTransformerSlots.getSlotX(), UniversalTransformerSlots.getSlotY(index)){

                protected ItemStack getRealStack() {
                    return (ItemStack)getStack.get();
                }

                protected void setRealStack(ItemStack itemStack) {
                    setStack.accept(itemStack);
                }

                public boolean mayPlace(ItemStack itemStack) {
                    return TransformerTierComponent.getTierFromCasing(itemStack) != null;
                }

                public int getMaxStackSize() {
                    return 1;
                }
            }, SlotGroup.CONFIGURABLE_STACKS);
        }

        public void setupMenu(GuiComponent.MenuFacade menu) {
            this.addSlot(menu, 0, this.transformerFrom::getStack, stack -> this.transformerFrom.setCasing(this.machine, (ItemStack)stack));
            this.addSlot(menu, 1, this.transformerTo::getStack, stack -> this.transformerTo.setCasing(this.machine, (ItemStack)stack));
        }
    }
}

