/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.mixin.mi;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import com.google.common.primitives.Ints;
import java.util.Map;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.swedz.extended_industrialization.EIFluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ConfigurableFluidStack.ConfigurableFluidSlot.class}, remap=false)
public class AllowFluidBottlesInMachinesMenuMixin {
    @Unique
    private static final int CAPACITY = 250;
    @Unique
    private static final Map<Fluid, ItemStack> BOTTLE_ITEMS = Map.of(Fluids.WATER, PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)Potions.WATER), EIFluids.HONEY.asFluid(), new ItemStack((ItemLike)Items.HONEY_BOTTLE));

    @Unique
    private FluidTank bottleTank(ItemStack item) {
        FluidTank tank = new FluidTank(250, v -> BOTTLE_ITEMS.containsKey(v.getFluid()));
        if (!item.is(Items.GLASS_BOTTLE)) {
            Optional<Fluid> optionalFluid = BOTTLE_ITEMS.entrySet().stream().filter(entry -> ItemStack.isSameItemSameTags((ItemStack)item, (ItemStack)((ItemStack)entry.getValue()))).map(Map.Entry::getKey).findFirst();
            optionalFluid.ifPresent(fluid -> tank.setFluid(new FluidStack(fluid, tank.getCapacity())));
        }
        return tank;
    }

    @Unique
    private FluidTank slotTank() {
        ConfigurableFluidStack.ConfigurableFluidSlot self = (ConfigurableFluidStack.ConfigurableFluidSlot)this;
        ConfigurableFluidStack configurableFluidStack = self.getConfStack();
        FluidTank tank = new FluidTank(Ints.saturatedCast((long)configurableFluidStack.getCapacity()), v -> self.canInsertFluid(FluidVariant.of((FluidStack)v)));
        tank.setFluid(configurableFluidStack.getVariant().toStack(Ints.saturatedCast((long)configurableFluidStack.getAmount())));
        return tank;
    }

    @Unique
    private boolean transfer(FluidTank destination, FluidTank source, FluidTank slotTank, ItemStack item, SlotAccess slot, Player player, IItemHandler inventory, ItemStack resultItem) {
        FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)false);
        if (transfer.getAmount() == 250) {
            if (player != null && player.getAbilities().instabuild) {
                FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)true);
                this.completed(transfer, slotTank, player);
                return true;
            }
            if (item.getCount() == 1) {
                FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)true);
                slot.set(resultItem.copy());
                this.completed(transfer, slotTank, player);
                return true;
            }
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)resultItem.copy(), (boolean)true);
            if (remainder.isEmpty() || player != null) {
                FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)true);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)resultItem.copy(), (boolean)false);
                if (!remainder.isEmpty() && player != null) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
                }
                ItemStack result = item.copy();
                result.shrink(1);
                slot.set(result);
                this.completed(transfer, slotTank, player);
                return true;
            }
        }
        return false;
    }

    @Unique
    private void completed(FluidStack transfer, FluidTank content, Player player) {
        SoundEvent soundevent;
        ConfigurableFluidStack configurableFluidStack = ((ConfigurableFluidStack.ConfigurableFluidSlot)this).getConfStack();
        configurableFluidStack.setKey((TransferVariant)FluidVariant.of((FluidStack)content.getFluid()));
        configurableFluidStack.setAmount((long)content.getFluidAmount());
        if (player != null && (soundevent = transfer.getFluidType().getSound(transfer, SoundActions.BUCKET_FILL)) != null) {
            player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Unique
    private boolean fillGlassBottle(ItemStack item, SlotAccess slot, Player player, IItemHandler inventory) {
        FluidTank destination = this.bottleTank(item);
        if (!destination.isEmpty()) {
            return false;
        }
        FluidTank source = this.slotTank();
        Fluid fluid = source.getFluid().getFluid();
        return this.transfer(destination, source, source, item, slot, player, inventory, BOTTLE_ITEMS.get(fluid));
    }

    @Unique
    private boolean emptyFluidBottle(ItemStack item, SlotAccess slot, Player player, IItemHandler inventory) {
        FluidTank source = this.bottleTank(item);
        if (source.isEmpty()) {
            return false;
        }
        FluidTank destination = this.slotTank();
        return this.transfer(destination, source, destination, item, slot, player, inventory, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
    }

    @Inject(method={"playerInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void playerInteract(SlotAccess slot, Player player, boolean allowSlotExtract, CallbackInfoReturnable<Boolean> callback) {
        ConfigurableFluidStack.ConfigurableFluidSlot self = (ConfigurableFluidStack.ConfigurableFluidSlot)this;
        ConfigurableFluidStack configurableFluidStack = self.getConfStack();
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.getInventory());
        ItemStack item = slot.get();
        if (item.getCapability(Capabilities.FluidHandler.ITEM) == null) {
            if (item.is(Items.GLASS_BOTTLE) && allowSlotExtract && !configurableFluidStack.isEmpty() && self.canExtractFluid(configurableFluidStack.getVariant())) {
                if (this.fillGlassBottle(item, slot, player, (IItemHandler)inventory)) {
                    callback.setReturnValue((Object)true);
                    return;
                }
            } else if (this.emptyFluidBottle(item, slot, player, (IItemHandler)inventory)) {
                callback.setReturnValue((Object)true);
                return;
            }
            callback.setReturnValue((Object)false);
        }
    }
}

