/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.client;

import com.mrbysco.rainshield.RainShield;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class RainShieldConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        RainShield.LOGGER.debug("Loaded Rain Shield's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        RainShield.LOGGER.warn("Rain Shield's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.IntValue rainShieldDistance;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.rainShieldDistance = builder.comment("Defines the range in which the Rain Shield stops rendering rain [default: 80]").defineInRange("rainShieldDistance", 80, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

