/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.datagen;

import com.mrbysco.rainshield.block.RainShieldBlock;
import com.mrbysco.rainshield.registry.RainShieldRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredBlock;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RainShieldDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new Language(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(packOutput, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput) {
            super(packOutput, Set.of(), null);
        }

        public List<LootTableProvider.SubProviderEntry> getTables() {
            return List.of(new LootTableProvider.SubProviderEntry(RainShieldBlockTables::new, LootContextParamSets.BLOCK));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> table.validate(validationContext));
        }

        public static class RainShieldBlockTables
        extends BlockLootSubProvider {
            protected RainShieldBlockTables() {
                super(Set.of(), FeatureFlags.REGISTRY.allFlags());
            }

            protected void generate() {
                this.dropSelf((Block)RainShieldRegistry.RAIN_SHIELD.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return RainShieldRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
            }
        }
    }

    public static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput) {
            super(packOutput);
        }

        protected void buildRecipes(RecipeOutput output) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)RainShieldRegistry.RAIN_SHIELD.get())).define(Character.valueOf('F'), (ItemLike)Items.FLINT).define(Character.valueOf('B'), Tags.Items.RODS_BLAZE).define(Character.valueOf('N'), Tags.Items.NETHERRACK).pattern(" F ").pattern(" B ").pattern("NNN").unlockedBy("has_blaze_rod", Recipes.has((TagKey)Tags.Items.RODS_BLAZE)).save(output);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "rainshield", "en_us");
        }

        protected void addTranslations() {
            this.addBlock((Supplier)RainShieldRegistry.RAIN_SHIELD, "Rain Shield");
            this.add("rainshield.networking.sync_shields.failed", "Failed to sync rain shield data: %s");
        }
    }

    private static class BlockModels
    extends BlockModelProvider {
        public BlockModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "rainshield", helper);
        }

        protected void registerModels() {
            this.makeRod(RainShieldRegistry.RAIN_SHIELD.getId());
        }

        private void makeRod(ResourceLocation location) {
            ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(location.getPath(), this.modLoc("block/rod"))).texture("particle", "block/" + location.getPath())).texture("rod", "block/" + location.getPath());
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "rainshield", helper);
        }

        protected void registerModels() {
            ResourceLocation location = RainShieldRegistry.RAIN_SHIELD_ITEM.getId();
            this.withExistingParent(location.getPath(), this.modLoc("block/" + location.getPath()));
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "rainshield", helper);
        }

        protected void registerStatesAndModels() {
            this.makeRod(RainShieldRegistry.RAIN_SHIELD);
        }

        private void makeRod(DeferredBlock<RainShieldBlock> deferredBlock) {
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + deferredBlock.getId().getPath()));
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)deferredBlock.get()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(270).addModel();
        }
    }
}

