/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.network.handler;

import com.mrbysco.rainshield.network.payloads.SyncShieldMapPayload;
import com.mrbysco.rainshield.util.RainShieldData;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleData(SyncShieldMapPayload payload, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            ListTag rainShieldMap = payload.shieldMapTag().getList("RainShieldMap", 10);
            HashMap shieldMap = new HashMap();
            for (int i = 0; i < rainShieldMap.size(); ++i) {
                CompoundTag listTag = rainShieldMap.getCompound(i);
                String dimension = listTag.getString("Dimension");
                ResourceLocation dimensionLocation = ResourceLocation.tryParse((String)dimension);
                ArrayList<BlockPos> blockPositionsList = new ArrayList<BlockPos>();
                ListTag blockPositions = listTag.getList("BlockPositions", 10);
                for (int j = 0; j < blockPositions.size(); ++j) {
                    CompoundTag blockPosTag = blockPositions.getCompound(j);
                    BlockPos pos = BlockPos.of((long)blockPosTag.getLong("BlockPos"));
                    blockPositionsList.add(pos);
                }
                shieldMap.put(dimensionLocation, blockPositionsList);
            }
            RainShieldData.rainShieldMap.clear();
            RainShieldData.rainShieldMap.putAll(shieldMap);
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"rainshield.networking.sync_shields.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

