/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining.enchantment;

import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.Services;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemProcessor {
    public static final Set<ItemChecker> ITEM_CHECKERS = new HashSet<ItemChecker>();

    public static synchronized void rebuild() {
        ITEM_CHECKERS.clear();
        VeinMiningConfig.COMMON.itemsList.clearCache();
        for (String s : (Set)VeinMiningConfig.COMMON.itemsList.getTransformed()) {
            ResourceLocation rl;
            if (s.startsWith("#")) {
                rl = ResourceLocation.tryParse((String)s.substring(1));
                Set<String> items = Services.PLATFORM.getItemsFromTag(rl);
                for (String item : items) {
                    ResourceLocation irl = ResourceLocation.tryParse((String)item);
                    if (irl == null) continue;
                    ITEM_CHECKERS.add(new ItemChecker(irl));
                }
                continue;
            }
            rl = ResourceLocation.tryParse((String)s);
            if (rl == null) continue;
            ITEM_CHECKERS.add(new ItemChecker(rl));
        }
    }

    public record ItemChecker(ResourceLocation resourceLocation) {
        private static final Map<String, Predicate<ItemStack>> PREDICATE_MAP = Services.PLATFORM.buildEnchantableItems();
        private static final BiPredicate<ResourceLocation, ItemStack> DEFAULT_PREDICATE = (resourceLocation, stack) -> Services.PLATFORM.getItem((ResourceLocation)resourceLocation).map(item -> item == stack.getItem()).orElse(false);

        public boolean test(ItemStack stack) {
            Predicate<ItemStack> predicate = PREDICATE_MAP.get(this.resourceLocation.toString());
            return predicate != null ? predicate.test(stack) : DEFAULT_PREDICATE.test(this.resourceLocation, stack);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemChecker that = (ItemChecker)o;
            return this.resourceLocation.equals((Object)that.resourceLocation);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.resourceLocation);
        }
    }
}

