/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining.enchantment;

import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.Services;
import com.illusivesoulworks.veinmining.common.veinmining.enchantment.ItemProcessor;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class VeinMiningEnchantment
extends Enchantment {
    public VeinMiningEnchantment() {
        super(Enchantment.Rarity.RARE, Services.PLATFORM.getEnchantmentCategory(), new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public static boolean canEnchant(Item item) {
        for (String entry : (Set)VeinMiningConfig.COMMON.itemsList.getTransformed()) {
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)entry);
            if (resourceLocation == null || !Services.PLATFORM.getItem(resourceLocation).map(found -> found == item).orElse(false).booleanValue()) continue;
            return true;
        }
        return item instanceof DiggerItem;
    }

    private static boolean canEnchantStack(ItemStack stack) {
        for (ItemProcessor.ItemChecker entry : ItemProcessor.ITEM_CHECKERS) {
            if (!entry.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Enchantment.Rarity getRarity() {
        return (Enchantment.Rarity)VeinMiningConfig.COMMON.rarity.get();
    }

    public int getMaxLevel() {
        return (Integer)VeinMiningConfig.COMMON.levels.get();
    }

    public int getMinCost(int enchantmentLevel) {
        return (Integer)VeinMiningConfig.COMMON.minEnchantabilityBase.get() + (Integer)VeinMiningConfig.COMMON.minEnchantabilityPerLevel.get() * (enchantmentLevel - 1);
    }

    public int getMaxCost(int enchantmentLevel) {
        return this.getMinCost(enchantmentLevel) + 50;
    }

    public boolean isTreasureOnly() {
        return (Boolean)VeinMiningConfig.COMMON.isTreasure.get();
    }

    public boolean isTradeable() {
        return (Boolean)VeinMiningConfig.COMMON.isVillagerTrade.get();
    }

    public boolean isDiscoverable() {
        return (Boolean)VeinMiningConfig.COMMON.isLootable.get();
    }

    protected boolean checkCompatibility(@Nonnull Enchantment ench) {
        return !((Set)VeinMiningConfig.COMMON.incompatibleEnchantments.getTransformed()).contains(ench) && super.checkCompatibility(ench);
    }

    public boolean canEnchant(@Nonnull ItemStack stack) {
        return VeinMiningEnchantment.canEnchantStack(stack);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack) {
        return this.canEnchant(stack) && (Boolean)VeinMiningConfig.COMMON.canApplyAtEnchantingTable.get() != false;
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)VeinMiningConfig.COMMON.canApplyOnBooks.get();
    }
}

