/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining.logic;

import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.Services;
import com.illusivesoulworks.veinmining.common.veinmining.logic.BlockGroups;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockProcessor {
    private static final Map<String, Boolean> checkedBlocks = new HashMap<String, Boolean>();
    private static final Map<String, Map<String, Boolean>> checkedPairs = new HashMap<String, Map<String, Boolean>>();
    private static final Map<String, Set<String>> checkedTags = new HashMap<String, Set<String>>();

    public static synchronized void rebuild() {
        checkedBlocks.clear();
        checkedPairs.clear();
        checkedTags.clear();
        BlockGroups.init();
    }

    public static boolean isValidTarget(BlockState state, Block source) {
        Block block = state.getBlock();
        return Services.PLATFORM.getResourceLocation(block).map(resourceLocation -> !state.isAir() && checkedBlocks.computeIfAbsent(resourceLocation.toString(), name -> BlockProcessor.checkBlock(state)) != false && BlockProcessor.matches(source, block)).orElse(false);
    }

    private static boolean matches(Block origin, Block target) {
        boolean useOriginKey;
        if (origin == target) {
            return true;
        }
        String originName = Services.PLATFORM.getResourceLocation(origin).map(ResourceLocation::toString).orElse("");
        String targetName = Services.PLATFORM.getResourceLocation(target).map(ResourceLocation::toString).orElse("");
        if (originName.isEmpty() && targetName.isEmpty()) {
            return false;
        }
        boolean bl = useOriginKey = originName.compareTo(targetName) >= 0;
        if (useOriginKey) {
            return checkedPairs.computeIfAbsent(originName, name -> new HashMap()).computeIfAbsent(targetName, name -> BlockProcessor.checkMatch(origin, target));
        }
        return checkedPairs.computeIfAbsent(targetName, name -> new HashMap()).computeIfAbsent(originName, name -> BlockProcessor.checkMatch(origin, target));
    }

    private static boolean checkBlock(BlockState blockState) {
        VeinMiningConfig.BlocksType blocksType = (VeinMiningConfig.BlocksType)((Object)VeinMiningConfig.SERVER.blocks.get());
        if (blocksType == VeinMiningConfig.BlocksType.ALL) {
            return true;
        }
        if (blocksType == VeinMiningConfig.BlocksType.NO_BLOCK_ENTITIES) {
            return !blockState.hasBlockEntity();
        }
        String blockId = Services.PLATFORM.getResourceLocation(blockState.getBlock()).map(ResourceLocation::toString).orElse("");
        if (blockId.isEmpty()) {
            return false;
        }
        HashSet<String> blockIds = new HashSet<String>();
        blockIds.add(blockId);
        Set tags = checkedTags.computeIfAbsent(blockId, name -> BlockProcessor.getTagsFor(blockState));
        tags.forEach(tag -> blockIds.add("#" + tag));
        boolean allow = true;
        HashSet<String> validIds = new HashSet<String>();
        switch (blocksType) {
            case ORES: {
                validIds.add("#c:ores");
                validIds.add("#forge:ores");
                break;
            }
            case ORES_LOGS: {
                validIds.add("#c:ores");
                validIds.add("#forge:ores");
                validIds.add("#minecraft:logs");
                break;
            }
            case ORES_STONE: {
                validIds.add("#c:ores");
                validIds.add("#forge:ores");
                validIds.add("#minecraft:base_stone_overworld");
                validIds.add("#minecraft:base_stone_nether");
                break;
            }
            case ORES_STONE_LOGS: {
                validIds.add("#c:ores");
                validIds.add("#forge:ores");
                validIds.add("#minecraft:logs");
                validIds.add("#minecraft:base_stone_overworld");
                validIds.add("#minecraft:base_stone_nether");
                break;
            }
            case CONFIG_LIST: {
                VeinMiningConfig.SERVER.blocksList.clearCache();
                Set set = (Set)VeinMiningConfig.SERVER.blocksList.getTransformed();
                validIds.addAll(set);
                allow = VeinMiningConfig.SERVER.blocksListType.get() == VeinMiningConfig.ListType.ALLOW;
            }
        }
        for (String id : validIds) {
            if (!blockIds.contains(id)) continue;
            return allow;
        }
        return !allow;
    }

    private static Set<String> getTagsFor(BlockState blockState) {
        HashSet<String> tags = new HashSet<String>();
        BuiltInRegistries.BLOCK.getTagNames().forEach(blockTagKey -> {
            if (blockState.is(blockTagKey)) {
                tags.add(blockTagKey.location().toString());
            }
        });
        return tags;
    }

    private static boolean checkMatch(Block origin, Block target) {
        String originName = Services.PLATFORM.getResourceLocation(origin).map(ResourceLocation::toString).orElse("");
        String targetName = Services.PLATFORM.getResourceLocation(target).map(ResourceLocation::toString).orElse("");
        if (originName.isEmpty() || targetName.isEmpty()) {
            return false;
        }
        return BlockGroups.getGroup(originName).contains(targetName);
    }
}

