/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining.logic;

import com.google.common.collect.Sets;
import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.Services;
import com.illusivesoulworks.veinmining.common.veinmining.logic.BlockProcessor;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VeinMiningLogic {
    private static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};

    public static void veinMine(ServerPlayer playerEntity, BlockPos pos, BlockState sourceState) {
        boolean tooSlow;
        ServerLevel world = playerEntity.serverLevel();
        ItemStack stack = playerEntity.getMainHandItem();
        Block source = sourceState.getBlock();
        boolean notCorrect = (Boolean)VeinMiningConfig.SERVER.requireCorrectTool.get() != false && !Services.PLATFORM.canHarvestDrops(playerEntity, sourceState);
        float destroySpeed = stack.getDestroySpeed(sourceState);
        boolean bl = tooSlow = destroySpeed > 0.0f && (double)destroySpeed < (Double)VeinMiningConfig.SERVER.requiredDestroySpeed.get();
        if (notCorrect || tooSlow) {
            return;
        }
        int veiningLevels = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Services.PLATFORM.getVeinMiningEnchantment(), (ItemStack)stack);
        int maxBlocks = (Integer)VeinMiningConfig.SERVER.maxBlocksBase.get() + (Integer)VeinMiningConfig.SERVER.maxBlocksPerLevel.get() * veiningLevels;
        int maxDistance = 200;
        if (maxBlocks <= 0) {
            return;
        }
        int blocks = 1;
        HashSet visited = Sets.newHashSet((Object[])new BlockPos[]{pos});
        LinkedList<Tuple<BlockPos, Integer>> candidates = new LinkedList<Tuple<BlockPos, Integer>>();
        VeinMiningLogic.addValidNeighbors(candidates, pos, 1);
        while (!candidates.isEmpty() && blocks < maxBlocks) {
            boolean limitByWorld;
            Tuple<BlockPos, Integer> candidate = candidates.poll();
            BlockPos blockPos = (BlockPos)candidate.getA();
            int blockDistance = (Integer)candidate.getB();
            boolean bl2 = limitByWorld = blockPos.getY() <= world.getMinBuildHeight() && (Boolean)VeinMiningConfig.SERVER.limitedByWorld.get() != false;
            if (limitByWorld || VeinMiningLogic.stopVeining(stack)) {
                return;
            }
            BlockState blockState = world.getBlockState(blockPos);
            if (!visited.add(blockPos) || !BlockProcessor.isValidTarget(blockState, source) || !Services.PLATFORM.harvest(playerEntity, blockPos, pos)) continue;
            if (blockDistance < maxDistance) {
                VeinMiningLogic.addValidNeighbors(candidates, blockPos, blockDistance + 1);
            }
            ++blocks;
        }
    }

    private static boolean stopVeining(ItemStack stack) {
        return stack.isDamageableItem() && (Boolean)VeinMiningConfig.SERVER.limitedByDurability.get() != false && (stack.getDamageValue() == stack.getMaxDamage() || (Boolean)VeinMiningConfig.SERVER.preventToolDestruction.get() != false && stack.getDamageValue() == stack.getMaxDamage() - 1);
    }

    private static void addValidNeighbors(LinkedList<Tuple<BlockPos, Integer>> candidates, BlockPos source, int distance) {
        if (((Boolean)VeinMiningConfig.SERVER.diagonalMining.get()).booleanValue()) {
            BlockPos[] blockPositions;
            BlockPos up = source.above();
            BlockPos down = source.below();
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)up, (Object)distance));
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)down, (Object)distance));
            for (BlockPos blockPos : blockPositions = new BlockPos[]{up, down, source}) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.west(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.east(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.north(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.south(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.north().west(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.north().east(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.south().west(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.south().east(), (Object)distance));
            }
        } else {
            for (Direction direction : CARDINAL_DIRECTIONS) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)source.relative(direction), (Object)distance));
            }
        }
    }
}

