/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.platform;

import com.google.common.collect.ImmutableMap;
import com.illusivesoulworks.veinmining.VeinMiningConstants;
import com.illusivesoulworks.veinmining.VeinMiningNeoForgeMod;
import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.services.IPlatform;
import com.illusivesoulworks.veinmining.common.veinmining.VeinMiningPlayers;
import com.illusivesoulworks.veinmining.common.veinmining.enchantment.VeinMiningEnchantment;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ToolAction;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.event.EventHooks;

public class NeoForgePlatform
implements IPlatform {
    private static final EnchantmentCategory CATEGORY = EnchantmentCategory.create((String)VeinMiningConstants.ENCHANTMENT_ID.toString(), VeinMiningEnchantment::canEnchant);

    @Override
    public Set<String> getBlocksFromTag(ResourceLocation resourceLocation) {
        HashSet<String> result = new HashSet<String>();
        BuiltInRegistries.BLOCK.getTagOrEmpty(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation)).forEach(holder -> {
            Block block = (Block)holder.value();
            ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)block);
            result.add(rl.toString());
        });
        return result;
    }

    @Override
    public EnchantmentCategory getEnchantmentCategory() {
        return CATEGORY;
    }

    @Override
    public Enchantment getVeinMiningEnchantment() {
        return VeinMiningNeoForgeMod.ENCHANTMENT.get();
    }

    @Override
    public Optional<Enchantment> getEnchantment(ResourceLocation resourceLocation) {
        return Optional.ofNullable((Enchantment)BuiltInRegistries.ENCHANTMENT.get(resourceLocation));
    }

    @Override
    public Optional<Item> getItem(ResourceLocation resourceLocation) {
        return Optional.of((Item)BuiltInRegistries.ITEM.get(resourceLocation));
    }

    @Override
    public Optional<Block> getBlock(ResourceLocation resourceLocation) {
        return Optional.of((Block)BuiltInRegistries.BLOCK.get(resourceLocation));
    }

    @Override
    public Optional<ResourceLocation> getResourceLocation(Enchantment enchantment) {
        return Optional.ofNullable(BuiltInRegistries.ENCHANTMENT.getKey((Object)enchantment));
    }

    @Override
    public Optional<ResourceLocation> getResourceLocation(Item item) {
        return Optional.of(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    @Override
    public Optional<ResourceLocation> getResourceLocation(Block block) {
        return Optional.of(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    @Override
    public Map<String, Predicate<ItemStack>> buildEnchantableItems() {
        HashMap<String, Predicate<ItemStack>> result = new HashMap<String, Predicate<ItemStack>>();
        result.put("is:tool", NeoForgePlatform::canToolAction);
        result.put("is:pickaxe", stack -> NeoForgePlatform.canToolAction(ToolActions.PICKAXE_DIG, stack));
        result.put("is:axe", stack -> NeoForgePlatform.canToolAction(ToolActions.AXE_DIG, stack));
        result.put("is:hoe", stack -> NeoForgePlatform.canToolAction(ToolActions.HOE_DIG, stack));
        result.put("is:shovel", stack -> NeoForgePlatform.canToolAction(ToolActions.SHOVEL_DIG, stack));
        return ImmutableMap.copyOf(result);
    }

    @Override
    public boolean canHarvestDrops(ServerPlayer playerEntity, BlockState state) {
        return CommonHooks.isCorrectToolForDrops((BlockState)state, (Player)playerEntity);
    }

    private static boolean canToolAction(ToolAction toolAction, ItemStack stack) {
        return stack.canPerformAction(toolAction);
    }

    private static boolean canToolAction(ItemStack stack) {
        Set<ToolAction> actions = Set.of(ToolActions.PICKAXE_DIG, ToolActions.AXE_DIG, ToolActions.HOE_DIG, ToolActions.SHOVEL_DIG);
        for (ToolAction action : actions) {
            if (!stack.canPerformAction(action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean harvest(ServerPlayer player, BlockPos pos, BlockPos originPos) {
        ServerLevel world = player.serverLevel();
        BlockState blockstate = world.getBlockState(pos);
        GameType gameType = player.gameMode.getGameModeForPlayer();
        int exp = CommonHooks.onBlockBreakEvent((Level)world, (GameType)gameType, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        BlockEntity blockentity = world.getBlockEntity(pos);
        Block block = blockstate.getBlock();
        if ((block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.canUseGameMasterBlocks()) {
            world.sendBlockUpdated(pos, blockstate, blockstate, 3);
            return false;
        }
        if (player.getMainHandItem().onBlockStartBreak(pos, (Player)player)) {
            return true;
        }
        if (player.blockActionRestricted((Level)world, pos, gameType)) {
            return false;
        }
        if (gameType.isCreative()) {
            NeoForgePlatform.removeBlock((Player)player, pos, false);
        } else {
            BlockPos spawnPos;
            ItemStack itemstack = player.getMainHandItem();
            ItemStack itemstack1 = itemstack.copy();
            boolean flag1 = blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player);
            itemstack.mineBlock((Level)world, blockstate, pos, (Player)player);
            if (itemstack.isEmpty() && !itemstack1.isEmpty()) {
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
            }
            boolean flag = NeoForgePlatform.removeBlock((Player)player, pos, flag1);
            BlockPos blockPos = spawnPos = (Boolean)VeinMiningConfig.SERVER.relocateDrops.get() != false ? originPos : pos;
            if (flag && flag1) {
                FoodData foodData = player.getFoodData();
                float currentExhaustion = foodData.getExhaustionLevel();
                VeinMiningPlayers.addMiningBlock((Level)world, pos, spawnPos);
                block.playerDestroy((Level)world, (Player)player, pos, blockstate, blockentity, itemstack1);
                VeinMiningPlayers.removeMiningBlock((Level)world, pos);
                if (((Boolean)VeinMiningConfig.SERVER.addExhaustion.get()).booleanValue()) {
                    float diff = foodData.getExhaustionLevel() - currentExhaustion;
                    foodData.setExhaustion(currentExhaustion);
                    foodData.addExhaustion((float)((double)diff * (Double)VeinMiningConfig.SERVER.exhaustionMultiplier.get()));
                } else {
                    foodData.setExhaustion(currentExhaustion);
                }
            }
            if (flag && exp > 0) {
                blockstate.getBlock().popExperience(world, spawnPos, exp);
            }
        }
        return true;
    }

    @Override
    public Set<String> getItemsFromTag(ResourceLocation resourceLocation) {
        HashSet<String> result = new HashSet<String>();
        BuiltInRegistries.ITEM.getTagOrEmpty(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation)).forEach(holder -> {
            Item item = (Item)holder.value();
            ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)item);
            result.add(rl.toString());
        });
        return result;
    }

    @Override
    public List<String> getDefaultItemsConfig() {
        return Arrays.asList("is:tool", "quark:pickarang", "quark:flamerang");
    }

    @Override
    public List<String> getDefaultGroups() {
        return Arrays.asList("#forge:obsidian", "#forge:ores/coal", "#forge:ores/diamond", "#forge:ores/emerald", "#forge:ores/gold", "#forge:ores/iron", "#forge:ores/lapis", "#forge:ores/redstone", "#forge:ores/quartz", "#forge:ores/netherite_scrap", "#forge:ores/copper", "#forge:ores/tin", "#forge:ores/osmium", "#forge:ores/uranium", "#forge:ores/fluorite", "#forge:ores/lead", "#forge:ores/zinc", "#forge:ores/aluminum", "#forge:ores/nickel", "#forge:ores/silver", "#forge:ores/apatite", "#forge:ores/cinnabar", "#forge:ores/niter", "#forge:ores/ruby", "#forge:ores/sapphire", "#forge:ores/sulfur");
    }

    private static boolean removeBlock(Player player, BlockPos pos, boolean canHarvest) {
        Level world = player.getCommandSenderWorld();
        BlockState state = world.getBlockState(pos);
        boolean removed = state.onDestroyedByPlayer(world, pos, player, canHarvest, world.getFluidState(pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)world, pos, state);
        }
        return removed;
    }
}

