/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModColourManager;
import mob_grinding_utils.ModContainers;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ModSounds;
import mob_grinding_utils.ServerResourceReloader;
import mob_grinding_utils.blocks.BlockSpikes;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.config.ServerConfig;
import mob_grinding_utils.datagen.Generator;
import mob_grinding_utils.events.BossBarHidingEvent;
import mob_grinding_utils.events.ChickenFuseEvent;
import mob_grinding_utils.events.EntityHeadDropEvent;
import mob_grinding_utils.events.EntityInteractionEvent;
import mob_grinding_utils.events.FillXPBottleEvent;
import mob_grinding_utils.events.GlobalDragonSoundEvent;
import mob_grinding_utils.events.GlobalWitherSoundEvent;
import mob_grinding_utils.events.LocalDragonSoundEvent;
import mob_grinding_utils.events.LocalWitherSoundEvent;
import mob_grinding_utils.events.MGUEndermanInhibitEvent;
import mob_grinding_utils.events.MGUZombieReinforcementEvent;
import mob_grinding_utils.events.RenderChickenSwell;
import mob_grinding_utils.inventory.client.GuiAbsorptionHopper;
import mob_grinding_utils.inventory.client.GuiFan;
import mob_grinding_utils.inventory.client.GuiMGUSpawner;
import mob_grinding_utils.inventory.client.GuiSaw;
import mob_grinding_utils.inventory.client.GuiXPSolidifier;
import mob_grinding_utils.network.FlagSyncPacket;
import mob_grinding_utils.network.MGUNetwork;
import mob_grinding_utils.recipe.BeheadingRecipe;
import mob_grinding_utils.recipe.ChickenFeedRecipe;
import mob_grinding_utils.recipe.FluidIngredient;
import mob_grinding_utils.recipe.SolidifyRecipe;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import mob_grinding_utils.tile.TileEntityMGUSpawner;
import mob_grinding_utils.tile.TileEntityTank;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import mob_grinding_utils.util.FakePlayerHandler;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mob_grinding_utils")
public class MobGrindingUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mob_grinding_utils");
    private static DamageSource SPIKE_DAMAGE;
    public static final ResourceKey<DamageType> SPIKE_TYPE;
    public static final DeferredRegister<ParticleType<?>> PARTICLES;
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES;
    public static final DeferredRegister<IngredientType<?>> INGREDIENTS;
    public static DeferredHolder<IngredientType<?>, IngredientType<FluidIngredient>> FLUID_INGREDIENT;
    public static final DeferredRegister<CreativeModeTab> TABS;
    public static final Supplier<CreativeModeTab> TAB;
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> PARTICLE_FLUID_XP;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> CHICKEN_FEED;
    public static final List<RecipeHolder<SolidifyRecipe>> SOLIDIFIER_RECIPES;
    public static final List<RecipeHolder<BeheadingRecipe>> BEHEADING_RECIPES;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SOLIDIFIER_RECIPE;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> BEHEADING_RECIPE;
    public static final DeferredHolder<RecipeType<?>, RecipeType<SolidifyRecipe>> SOLIDIFIER_TYPE;
    public static final DeferredHolder<RecipeType<?>, RecipeType<BeheadingRecipe>> BEHEADING_TYPE;

    public MobGrindingUtils(IEventBus modBus) {
        IEventBus neoBus = NeoForge.EVENT_BUS;
        ModBlocks.init(modBus);
        ModItems.init(modBus);
        ModContainers.init(modBus);
        PARTICLES.register(modBus);
        RECIPES.register(modBus);
        RECIPE_TYPES.register(modBus);
        TABS.register(modBus);
        INGREDIENTS.register(modBus);
        ModSounds.init(modBus);
        if (FMLEnvironment.dist.isClient()) {
            ModelLayers.init(modBus);
            modBus.addListener(this::doClientStuff);
            modBus.addListener(this::menuScreenEvent);
        }
        modBus.addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SERVER_CONFIG);
        neoBus.addListener(BlockSpikes::dropXP);
        neoBus.register((Object)new EntityInteractionEvent());
        neoBus.register((Object)new ChickenFuseEvent());
        neoBus.register((Object)new LocalWitherSoundEvent());
        neoBus.register((Object)new LocalDragonSoundEvent());
        neoBus.register((Object)new EntityHeadDropEvent());
        neoBus.register((Object)new MGUZombieReinforcementEvent());
        neoBus.register((Object)new FillXPBottleEvent());
        neoBus.register((Object)new MGUEndermanInhibitEvent());
        neoBus.addListener(this::playerConnected);
        neoBus.addListener(this::changedDimension);
        neoBus.addListener(this::playerRespawn);
        neoBus.addListener(this::cloneEvent);
        neoBus.addListener(this::serverReloadListener);
        neoBus.addListener(this::clientRecipeReload);
        neoBus.addListener(this::effectApplicable);
        modBus.addListener(this::registerCaps);
        modBus.addListener(MGUNetwork::register);
        modBus.addListener(Generator::gatherData);
    }

    public void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        IEventBus neoBus = NeoForge.EVENT_BUS;
        neoBus.register((Object)new RenderChickenSwell());
        neoBus.register((Object)new GlobalWitherSoundEvent());
        neoBus.register((Object)new GlobalDragonSoundEvent());
        neoBus.register((Object)new BossBarHidingEvent());
        neoBus.addListener(this::worldUnload);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModBlocks.FLUID_XP_FLOWING.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModBlocks.FLUID_XP.get()), (RenderType)RenderType.translucent());
        event.enqueueWork(ModColourManager::registerColourHandlers);
    }

    private void menuScreenEvent(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModContainers.ABSORPTION_HOPPER.get(), GuiAbsorptionHopper::new);
        event.register((MenuType)ModContainers.SOLIDIFIER.get(), GuiXPSolidifier::new);
        event.register((MenuType)ModContainers.FAN.get(), GuiFan::new);
        event.register((MenuType)ModContainers.SAW.get(), GuiSaw::new);
        event.register((MenuType)ModContainers.ENTITY_SPAWNER.get(), GuiMGUSpawner::new);
    }

    private void serverReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ServerResourceReloader(event.getServerResources()));
    }

    private void clientRecipeReload(RecipesUpdatedEvent event) {
        SOLIDIFIER_RECIPES.clear();
        SOLIDIFIER_RECIPES.addAll(event.getRecipeManager().getAllRecipesFor((RecipeType)SOLIDIFIER_TYPE.get()));
    }

    private void playerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.sendPersistentData((ServerPlayer)event.getEntity());
        }
    }

    private void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.sendPersistentData((ServerPlayer)event.getEntity());
        }
    }

    private void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.sendPersistentData((ServerPlayer)event.getEntity());
        }
    }

    private void sendPersistentData(ServerPlayer playerEntity) {
        CompoundTag nbt = playerEntity.getPersistentData();
        if (nbt.contains("MGU_WitherMuffle") || nbt.contains("MGU_DragonMuffle")) {
            PacketDistributor.PLAYER.with((Object)playerEntity).send(new CustomPacketPayload[]{new FlagSyncPacket(nbt.getBoolean("MGU_WitherMuffle"), nbt.getBoolean("MGU_DragonMuffle"))});
        }
    }

    private void cloneEvent(PlayerEvent.Clone event) {
        CompoundTag nbt = event.getOriginal().getPersistentData();
        if (nbt.contains("MGU_WitherMuffle") || nbt.contains("MGU_DragonMuffle")) {
            CompoundTag newNBT = event.getEntity().getPersistentData();
            newNBT.putBoolean("MGU_WitherMuffle", nbt.getBoolean("MGU_WitherMuffle"));
            newNBT.putBoolean("MGU_DragonMuffle", nbt.getBoolean("MGU_DragonMuffle"));
        }
    }

    private void worldUnload(LevelEvent.Unload event) {
        if (event.getLevel() instanceof ServerLevel) {
            SPIKE_DAMAGE = null;
        }
    }

    public static DamageSource getSpikeDamage(Level level) {
        if (SPIKE_DAMAGE == null) {
            SPIKE_DAMAGE = new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(SPIKE_TYPE));
        }
        return SPIKE_DAMAGE;
    }

    public void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.registerBlockEntity(Capabilities.FluidHandler.BLOCK, ModBlocks.TANK.getTileEntityType(), TileEntityTank::getTank);
        evt.registerBlockEntity(Capabilities.FluidHandler.BLOCK, ModBlocks.JUMBO_TANK.getTileEntityType(), TileEntityTank::getTank);
        evt.registerBlockEntity(Capabilities.FluidHandler.BLOCK, ModBlocks.TANK_SINK.getTileEntityType(), TileEntityTank::getTank);
        evt.registerBlockEntity(Capabilities.FluidHandler.BLOCK, ModBlocks.XPSOLIDIFIER.getTileEntityType(), TileEntityXPSolidifier::getTank);
        evt.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlocks.XPSOLIDIFIER.getTileEntityType(), TileEntityXPSolidifier::getOutput);
        evt.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlocks.ENTITY_SPAWNER.getTileEntityType(), TileEntityMGUSpawner::getFuelSlot);
        evt.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlocks.ABSORPTION_HOPPER.getTileEntityType(), TileEntityAbsorptionHopper::getItemHandler);
        evt.registerBlockEntity(Capabilities.FluidHandler.BLOCK, ModBlocks.ABSORPTION_HOPPER.getTileEntityType(), TileEntityAbsorptionHopper::getTank);
    }

    public void effectApplicable(MobEffectEvent.Applicable event) {
        FakePlayer fakePlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof FakePlayer && FakePlayerHandler.isMGUFakePlayer(fakePlayer = (FakePlayer)livingEntity)) {
            event.setResult(Event.Result.DENY);
        }
    }

    static {
        SPIKE_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("mob_grinding_utils", "spikes"));
        PARTICLES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"mob_grinding_utils");
        RECIPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"mob_grinding_utils");
        RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"mob_grinding_utils");
        INGREDIENTS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.INGREDIENT_TYPES, (String)"mob_grinding_utils");
        FLUID_INGREDIENT = INGREDIENTS.register("fluid", () -> new IngredientType(FluidIngredient.CODEC));
        TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"mob_grinding_utils");
        TAB = TABS.register("tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ModBlocks.SPIKES.get())).title((Component)Component.translatable((String)"itemGroup.mob_grinding_utils")).displayItems((params, output) -> {
            ModBlocks.TAB_ORDER.forEach(block -> output.accept(block.getItem()));
            ModItems.TAB_ORDER.forEach(item -> output.accept((ItemLike)item.get()));
        }).build());
        PARTICLE_FLUID_XP = PARTICLES.register("fluid_xp_particles", () -> new SimpleParticleType(true));
        CHICKEN_FEED = RECIPES.register("chicken_feed", ChickenFeedRecipe.Serializer::new);
        SOLIDIFIER_RECIPES = new ArrayList<RecipeHolder<SolidifyRecipe>>();
        BEHEADING_RECIPES = new ArrayList<RecipeHolder<BeheadingRecipe>>();
        SOLIDIFIER_RECIPE = RECIPES.register("solidify", SolidifyRecipe.Serializer::new);
        BEHEADING_RECIPE = RECIPES.register("beheading", BeheadingRecipe.Serializer::new);
        SOLIDIFIER_TYPE = RECIPE_TYPES.register("solidify", RecipeType::simple);
        BEHEADING_TYPE = RECIPE_TYPES.register("beheading", RecipeType::simple);
    }
}

