/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.tile.TileEntitySaw;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockSaw
extends DirectionalBlock
implements EntityBlock {
    public static final MapCodec<BlockSaw> CODEC = BlockSaw.simpleCodec(BlockSaw::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final VoxelShape SAW_AABB = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public BlockSaw(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEntitySaw(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, @Nonnull BlockState pState, @Nonnull BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? TileEntitySaw::clientTick : TileEntitySaw::serverTick;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SAW_AABB;
    }

    @Nonnull
    public VoxelShape getInteractionShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return Shapes.block();
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public void setPlacedBy(@Nonnull Level world, @Nonnull BlockPos pos, BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity be = world.getBlockEntity(pos);
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && be instanceof TileEntitySaw) {
            TileEntitySaw tile = (TileEntitySaw)be;
            tile.setActive(true);
            if (placer instanceof Player) {
                Player player = (Player)placer;
                tile.setPlacer(player);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    @Nonnull
    public InteractionResult use(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity tileentity;
        if (!world.isClientSide && (tileentity = world.getBlockEntity(pos)) instanceof TileEntitySaw) {
            player.openMenu((MenuProvider)((TileEntitySaw)tileentity), pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            TileEntitySaw tile = (TileEntitySaw)world.getBlockEntity(pos);
            if (tile != null) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)tile);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public void neighborChanged(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (!world.isClientSide) {
            TileEntitySaw tile = (TileEntitySaw)world.getBlockEntity(pos);
            boolean flag = (Boolean)state.getValue((Property)POWERED);
            if (flag != world.hasNeighborSignal(pos)) {
                if (flag) {
                    world.scheduleTick(pos, (Block)this, 4);
                } else {
                    world.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                    if (tile != null) {
                        tile.setActive((Boolean)state.getValue((Property)POWERED) == false);
                    }
                }
            }
        }
    }

    public void tick(@Nonnull BlockState state, ServerLevel world, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (!world.isClientSide) {
            TileEntitySaw tile = (TileEntitySaw)world.getBlockEntity(pos);
            if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !world.hasNeighborSignal(pos)) {
                world.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                if (tile != null) {
                    tile.setActive((Boolean)state.getValue((Property)POWERED) == false);
                }
            }
        }
    }

    public boolean getWeakChanges(BlockState state, LevelReader world, BlockPos pos) {
        return state.is((Block)ModBlocks.SAW.getBlock());
    }
}

