/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModSounds;
import mob_grinding_utils.blocks.BlockTank;
import mob_grinding_utils.tile.TileEntityXPTap;
import mob_grinding_utils.util.CapHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockXPTap
extends DirectionalBlock
implements EntityBlock {
    public static final MapCodec<BlockXPTap> CODEC = BlockXPTap.simpleCodec(BlockXPTap::new);
    public static final VoxelShape XP_TAP_WEST_AABB = Block.box((double)7.0, (double)6.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public static final VoxelShape XP_TAP_EAST_AABB = Block.box((double)0.0, (double)6.0, (double)4.0, (double)9.0, (double)16.0, (double)12.0);
    public static final VoxelShape XP_TAP_SOUTH_AABB = Block.box((double)4.0, (double)6.0, (double)0.0, (double)12.0, (double)16.0, (double)9.0);
    public static final VoxelShape XP_TAP_NORTH_AABB = Block.box((double)4.0, (double)6.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0);
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");

    public BlockXPTap(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> XP_TAP_EAST_AABB;
            case Direction.WEST -> XP_TAP_WEST_AABB;
            case Direction.SOUTH -> XP_TAP_SOUTH_AABB;
            default -> XP_TAP_NORTH_AABB;
        };
    }

    @Nonnull
    public VoxelShape getInteractionShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> XP_TAP_EAST_AABB;
            case Direction.WEST -> XP_TAP_WEST_AABB;
            case Direction.SOUTH -> XP_TAP_SOUTH_AABB;
            default -> XP_TAP_NORTH_AABB;
        };
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Nonnull
    public InteractionResult use(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (!world.isClientSide) {
            boolean swap = (Boolean)state.getValue((Property)POWERED);
            world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(!swap)), 3);
            float f = (Boolean)state.getValue((Property)POWERED) != false ? 0.6f : 0.5f;
            world.playSound(null, pos, (SoundEvent)ModSounds.TAP_SQUEAK.get(), SoundSource.BLOCKS, 0.3f, f);
            TileEntityXPTap tileentity = (TileEntityXPTap)world.getBlockEntity(pos);
            tileentity.setActive(!swap);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader world, @Nonnull BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!this.canPlaceAt(world, pos.relative(enumfacing.getOpposite()), enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(LevelReader world, BlockPos pos, Direction facing) {
        BlockState blockstate = world.getBlockState(pos);
        boolean isSide = facing.getAxis().isHorizontal();
        BlockEntity te = world.getBlockEntity(pos);
        if (te != null && te.getLevel() != null && CapHelper.getFluidHandler(te.getLevel(), pos, facing).isPresent() && isSide) {
            return true;
        }
        return isSide && blockstate.getBlock() instanceof BlockTank;
    }

    public void neighborChanged(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        Direction facing = (Direction)world.getBlockState(pos).getValue((Property)FACING);
        if (!this.canPlaceAt((LevelReader)world, pos.relative(facing.getOpposite()), facing)) {
            BlockXPTap.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModBlocks.XP_TAP.getItem(), 1));
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEntityXPTap(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, @Nonnull BlockState pState, @Nonnull BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? null : TileEntityXPTap::serverTick;
    }
}

