/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.jei;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.client.jei.JEIPlugin;
import mob_grinding_utils.recipe.SolidifyRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class SolidifierCategory
implements IRecipeCategory<SolidifyRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("mob_grinding_utils", "solidifier_jei");
    private final IDrawableStatic background;

    public SolidifierCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("mob_grinding_utils", "textures/gui/solidifier_jei.png"), 0, 0, 91, 26).setTextureSize(91, 26).build();
    }

    @Nonnull
    public RecipeType<SolidifyRecipe> getRecipeType() {
        return JEIPlugin.SOLIDIFY_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"mob_grinding_utiles.jei.solidifier");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SolidifyRecipe recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 5, 5).addIngredients(recipe.mould());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 37, 5).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, List.of(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), recipe.fluidAmount())))).addTooltipCallback((recipeSlot, tooltip) -> {
            Optional ingredient = recipeSlot.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK);
            ingredient.ifPresent(fluidStack -> {
                tooltip.add(Component.literal((String)(fluidStack.getAmount() + " mB")));
                tooltip.add(Component.translatable((String)"mob_grinding_utils.jei.any_experience").withStyle(ChatFormatting.GRAY));
            });
        });
        builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 5).addItemStack(recipe.getResultItem((RegistryAccess)RegistryAccess.EMPTY));
    }
}

