/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockXPSolidifier;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.models.ModelXPSolidifier;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityXPSolidifierRenderer
implements BlockEntityRenderer<TileEntityXPSolidifier> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/xp_solidifier.png");
    private static final ResourceLocation TEXTURE_NO_PUSH = new ResourceLocation("mob_grinding_utils:textures/tiles/xp_solidifier_no_push.png");
    private final ModelXPSolidifier xp_solidifier_model;

    public TileEntityXPSolidifierRenderer(BlockEntityRendererProvider.Context context) {
        this.xp_solidifier_model = new ModelXPSolidifier(context.bakeLayer(ModelLayers.XPSOLIDIFIER));
    }

    public void render(TileEntityXPSolidifier tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.hasLevel()) {
            return;
        }
        BlockState state = tile.getLevel().getBlockState(tile.getBlockPos());
        if (state == null || state.getBlock() != ModBlocks.XPSOLIDIFIER.getBlock()) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)BlockXPSolidifier.FACING);
        float ticks = (float)tile.prevAnimationTicks + (float)(tile.animationTicks - tile.prevAnimationTicks) * partialTicks;
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.5, 0.5);
        matrixStack.scale(-0.9999f, -0.9999f, 0.9999f);
        switch (tile.outputDirection) {
            case NONE: 
            case NORTH: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                matrixStack.mulPose(Axis.YN.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case EAST: {
                matrixStack.mulPose(Axis.YN.rotationDegrees(180.0f));
                break;
            }
            default: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.renderExport(matrixStack, bufferIn.getBuffer(RenderType.entitySmoothCutout((ResourceLocation)(tile.outputDirection == TileEntityXPSolidifier.OutputDirection.NONE ? TEXTURE_NO_PUSH : TEXTURE))), combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.5, 0.5);
        matrixStack.scale(-0.9999f, -0.9999f, 0.9999f);
        switch (facing) {
            case NORTH: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case SOUTH: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                matrixStack.mulPose(Axis.YN.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
        }
        matrixStack.pushPose();
        RenderSystem.enableBlend();
        if (ticks > 0.0f && ticks <= 20.0f) {
            matrixStack.translate(0.0, (double)(ticks * 0.009375f), 0.0);
        }
        if (ticks > 20.0f && ticks <= 60.0f) {
            matrixStack.translate(0.0, 0.1875, 0.0);
        }
        if (ticks > 60.0f && ticks <= 80.0f) {
            matrixStack.translate(0.0, (double)((80.0f - ticks) * 0.009375f), 0.0);
        }
        if (ticks > 80.0f || ticks <= 0.0f) {
            matrixStack.translate(0.0, 0.0, 0.0);
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.renderRack(matrixStack, bufferIn.getBuffer(RenderType.entitySmoothCutout((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.60625, -0.22);
        matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStack.scale(1.25f, 1.25f, 1.25f);
        ItemStack stackMould = tile.inputSlots.getStackInSlot(0);
        if (!stackMould.isEmpty()) {
            Minecraft.getInstance().getTextureManager().bindForSetup(InventoryMenu.BLOCK_ATLAS);
            Minecraft.getInstance().getItemRenderer().render(stackMould, ItemDisplayContext.GROUND, false, matrixStack, bufferIn, combinedLight, combinedOverlay, Minecraft.getInstance().getItemRenderer().getModel(stackMould, null, null, 0));
        }
        matrixStack.popPose();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.popPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.renderToBuffer(matrixStack, bufferIn.getBuffer(RenderType.entitySmoothCutout((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.79375, -0.22);
        matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStack.scale(1.25f, 1.25f, 1.25f);
        ItemStack stackResult = tile.outputSlot.getStackInSlot(0);
        if (stackResult.isEmpty() && !tile.getCachedOutPutRenderStack().isEmpty() && tile.getProgress() > 60) {
            Minecraft.getInstance().getTextureManager().bindForSetup(InventoryMenu.BLOCK_ATLAS);
            Minecraft.getInstance().getItemRenderer().render(tile.getCachedOutPutRenderStack(), ItemDisplayContext.GROUND, false, matrixStack, bufferIn, combinedLight, combinedOverlay, Minecraft.getInstance().getItemRenderer().getModel(tile.getCachedOutPutRenderStack(), null, null, 0));
        } else if (!stackResult.isEmpty()) {
            Minecraft.getInstance().getTextureManager().bindForSetup(InventoryMenu.BLOCK_ATLAS);
            Minecraft.getInstance().getItemRenderer().render(stackResult, ItemDisplayContext.GROUND, false, matrixStack, bufferIn, combinedLight, combinedOverlay, Minecraft.getInstance().getItemRenderer().getModel(stackResult, null, null, 0));
        }
        matrixStack.popPose();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.popPose();
        if (tile.tank.getFluid().isEmpty()) {
            return;
        }
        float fluidLevel = tile.tank.getFluidAmount();
        if (fluidLevel < 1.0f) {
            return;
        }
        FluidStack fluidStack = new FluidStack(tile.tank.getFluid(), 100);
        float height = 0.46875f / (float)tile.tank.getCapacity() * (float)tile.tank.getFluidAmount();
        IClientFluidTypeExtensions fluidExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidExtensions.getStillTexture());
        VertexConsumer buffer = bufferIn.getBuffer(RenderType.translucent());
        int fluidColor = fluidExtensions.getTintColor();
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.0, 0.0);
        float yMin = 0.0f;
        float xMax = 1.984375f;
        float zMax = 1.984375f;
        float xMin = 0.015625f;
        float zMin = 0.015625f;
        yMin = 0.015625f;
        float alpha = 1.0f;
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
        matrixStack.popPose();
        if (ticks > 20.0f && ticks < 60.0f && !stackMould.isEmpty()) {
            matrixStack.pushPose();
            switch (facing) {
                case NORTH: {
                    matrixStack.translate(0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    matrixStack.translate(0.0, 0.0, 0.125);
                    break;
                }
                case WEST: {
                    matrixStack.translate(-0.0625, 0.0, 0.0625);
                    break;
                }
                case EAST: {
                    matrixStack.translate(0.0625, 0.0, 0.0625);
                    break;
                }
            }
            xMax = 1.62f;
            zMax = 1.5f;
            xMin = 0.38f;
            zMin = 0.25f;
            yMin = 0.6875f;
            this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, 0.6875f + ticks * 6.25E-4f, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
            matrixStack.popPose();
        }
    }

    private void renderCuboid(VertexConsumer buffer, PoseStack matrixStack, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite, float red, float green, float blue, float alpha, int combinedLight) {
        float uMin = textureAtlasSprite.getU0();
        float uMax = textureAtlasSprite.getU1();
        float vMin = textureAtlasSprite.getV0();
        float vMax = textureAtlasSprite.getV1();
        float vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMax, red, green, blue, alpha, combinedLight);
    }

    private void addVertexWithUV(VertexConsumer buffer, PoseStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, int combinedLight) {
        buffer.vertex(matrixStack.last().pose(), x / 2.0f, y, z / 2.0f).color(red, green, blue, alpha).uv(u, v).uv2(combinedLight, 240).normal(1.0f, 0.0f, 0.0f).endVertex();
    }
}

