/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.models.ModelSawBase;
import mob_grinding_utils.models.ModelSawBlade;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileSawStackItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/saw_base.png");
    private static final ResourceLocation BLADE_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/saw_blade.png");
    private final ModelSawBase saw_base;
    private final ModelSawBlade saw_blade;

    public TileSawStackItemRenderer(BlockEntityRenderDispatcher renderer, EntityModelSet modelSet) {
        super(renderer, modelSet);
        EntityModelSet EntityModelSetThatIsntNULL = Minecraft.getInstance().getEntityModels();
        this.saw_base = new ModelSawBase(EntityModelSetThatIsntNULL.bakeLayer(ModelLayers.SAW_BASE));
        this.saw_blade = new ModelSawBlade(EntityModelSetThatIsntNULL.bakeLayer(ModelLayers.SAW_BLADE));
    }

    public void renderByItem(@Nonnull ItemStack itemStackIn, @Nonnull ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlayIn) {
        VertexConsumer ivertexbuilder = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)BASE_TEXTURE));
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.5, 0.5);
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        this.saw_base.renderToBuffer(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        this.saw_base.renderAxle(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        this.saw_base.renderMace(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(165.0f));
        this.saw_base.renderMace(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(285.0f));
        this.saw_base.renderMace(matrixStack, ivertexbuilder, combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.2f, -0.16f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(8.0f));
        this.saw_blade.renderToBuffer(matrixStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)BLADE_TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 0.16f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-8.0f));
        this.saw_blade.renderToBuffer(matrixStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)BLADE_TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, -0.2f, -0.16f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(8.0f));
        this.saw_blade.renderToBuffer(matrixStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)BLADE_TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        matrixStack.popPose();
    }
}

