/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.events;

import java.util.Optional;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ModSounds;
import mob_grinding_utils.network.ChickenSyncPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ChickenFuseEvent {
    @Nonnull
    public static ItemStack getSpawnEgg(@Nonnull EntityType<?> entityType) {
        SpawnEggItem egg = SpawnEggItem.byId(entityType);
        return egg != null ? new ItemStack((ItemLike)egg) : ItemStack.EMPTY;
    }

    @SubscribeEvent
    public void startChickenFuse(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Chicken) {
            CompoundTag nbt;
            Level world = entity.getCommandSenderWorld();
            if (!world.isClientSide && (nbt = entity.getPersistentData()).contains("shouldExplode")) {
                int startTime = event.getEntity().getPersistentData().getInt("countDown");
                if (startTime <= 19) {
                    nbt.putInt("countDown", nbt.getInt("countDown") + 1);
                    PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{new ChickenSyncPacket(entity, nbt)});
                }
                if (startTime >= 20) {
                    Optional entityMob = EntityType.byString((String)event.getEntity().getPersistentData().getString("mguMobName"));
                    entityMob.ifPresent(mob -> {
                        ItemStack eggItem = ChickenFuseEvent.getSpawnEgg(mob);
                        if (eggItem != ItemStack.EMPTY) {
                            entity.spawnAtLocation(eggItem, 0.0f);
                        }
                    });
                    if (nbt.contains("nutritious") && nbt.getBoolean("nutritious")) {
                        entity.spawnAtLocation(new ItemStack((ItemLike)ModItems.GOLDEN_EGG.get()), 0.0f);
                    }
                    if (nbt.contains("cursed") && nbt.getBoolean("cursed")) {
                        entity.spawnAtLocation(new ItemStack((ItemLike)ModItems.ROTTEN_EGG.get()), 0.0f);
                        entity.playSound((SoundEvent)ModSounds.SPOOPY_CHANGE.get(), 1.0f, 1.0f);
                    } else {
                        entity.playSound(SoundEvents.CHICKEN_DEATH, 1.0f, 1.0f);
                        entity.playSound((SoundEvent)ModSounds.CHICKEN_RISE.get(), 0.5f, 1.0f);
                    }
                    for (int k = 0; k < 4; ++k) {
                        ItemStack stack = new ItemStack((ItemLike)Items.FEATHER);
                        ItemEntity feather = new ItemEntity(world, entity.getX() + (double)(world.random.nextFloat() * entity.getBbWidth() * 2.0f) - (double)entity.getBbWidth(), entity.getY() + (double)(world.random.nextFloat() * entity.getBbHeight()), entity.getZ() + (double)(world.random.nextFloat() * entity.getBbWidth() * 2.0f) - (double)entity.getBbWidth(), stack);
                        world.addFreshEntity((Entity)feather);
                    }
                    entity.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }
}

