/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.events;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Optional;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.items.ItemImaginaryInvisibleNotReallyThereSword;
import mob_grinding_utils.recipe.BeheadingRecipe;
import mob_grinding_utils.util.FakePlayerHandler;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class EntityHeadDropEvent {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropEvent(LivingDropsEvent event) {
        FakePlayer fakePlayer;
        if (event.getEntity().level().isClientSide) {
            return;
        }
        if (event.getEntity().getHealth() > 0.0f) {
            return;
        }
        int beheadingLevel = 0;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof FakePlayer && FakePlayerHandler.isMGUFakePlayer(fakePlayer = (FakePlayer)entity) && fakePlayer.getMainHandItem().getItem() instanceof ItemImaginaryInvisibleNotReallyThereSword) {
            ItemStack stack;
            int dropChance;
            ItemStack tempSword = fakePlayer.getMainHandItem();
            if (tempSword.hasTag() && tempSword.getTag().contains("beheadingValue")) {
                beheadingLevel = tempSword.getTag().getInt("beheadingValue");
            }
            if ((dropChance = event.getEntity().getCommandSenderWorld().random.nextInt(10)) < beheadingLevel && !(stack = EntityHeadDropEvent.getHeadFromEntity(event.getEntity())).isEmpty()) {
                this.addDrop(stack, event.getEntity(), event.getDrops());
            }
        }
    }

    public static ItemStack getHeadFromEntity(LivingEntity target) {
        if (target.isBaby()) {
            return ItemStack.EMPTY;
        }
        Optional<RecipeHolder> recipeOptional = MobGrindingUtils.BEHEADING_RECIPES.stream().filter(recipe -> ((BeheadingRecipe)recipe.value()).matches(target.getType())).findFirst();
        if (recipeOptional.isPresent()) {
            return ((BeheadingRecipe)recipeOptional.get().value()).getResultItem((RegistryAccess)RegistryAccess.EMPTY);
        }
        if (target instanceof Mob && ModList.get().isLoaded("player_mobs") && EntityHeadDropEvent.isPlayerMob((Entity)target)) {
            return EntityHeadDropEvent.createHeadFor(EntityHeadDropEvent.getPlayerByUsername(target.getName().getString()));
        }
        if (target instanceof Player) {
            return EntityHeadDropEvent.createHeadFor((Player)target);
        }
        return ItemStack.EMPTY;
    }

    public static boolean isPlayerMob(Entity entity) {
        Optional entityMob = EntityType.byString((String)"player_mobs:player_mob");
        return entityMob.isPresent() && ((EntityType)entityMob.get()).equals(entity.getType());
    }

    public static GameProfile getPlayerByUsername(String name) {
        return new GameProfile(null, name);
    }

    public static ItemStack createHeadFor(Player player) {
        return EntityHeadDropEvent.createHeadFor(player.getGameProfile());
    }

    public static ItemStack createHeadFor(GameProfile profile) {
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD, 1);
        stack.setTag(new CompoundTag());
        CompoundTag profileData = new CompoundTag();
        NbtUtils.writeGameProfile((CompoundTag)profileData, (GameProfile)profile);
        stack.getTag().put("SkullOwner", (Tag)profileData);
        return stack;
    }

    private void addDrop(ItemStack stack, LivingEntity entity, Collection<ItemEntity> collection) {
        if (stack.getCount() <= 0) {
            return;
        }
        ItemEntity entityItem = new ItemEntity(entity.getCommandSenderWorld(), entity.getX(), entity.getY(), entity.getZ(), stack);
        entityItem.setDefaultPickUpDelay();
        collection.add(entityItem);
    }
}

