/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import javax.annotation.Nonnull;
import mob_grinding_utils.inventory.client.GuiMGUButton;
import mob_grinding_utils.inventory.client.MGUScreen;
import mob_grinding_utils.inventory.server.ContainerFan;
import mob_grinding_utils.network.BEGuiClick;
import mob_grinding_utils.tile.TileEntityFan;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class GuiFan
extends MGUScreen<ContainerFan> {
    protected final ContainerFan container;
    private final TileEntityFan tile;

    public GuiFan(ContainerFan container, Inventory inventory, Component title) {
        super(container, inventory, title, new ResourceLocation("mob_grinding_utils:textures/gui/fan_gui.png"));
        this.container = container;
        this.tile = this.container.fan;
        this.imageHeight = 150;
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 54, this.topPos + 42, GuiMGUButton.Size.LARGE, 0, (Component)Component.empty(), button -> {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new BEGuiClick(this.tile.getBlockPos(), 0)});
            this.tile.showRenderBox = !this.tile.showRenderBox;
        }));
    }

    @Override
    protected void renderLabels(@Nonnull GuiGraphics gg, int mouseX, int mouseY) {
        super.renderLabels(gg, mouseX, mouseY);
        gg.drawString(this.font, !this.tile.showRenderBox ? "Show Area" : "Hide Area", (float)(this.imageWidth - 88) - (float)this.font.width(!this.tile.showRenderBox ? "Show Area" : "Hide Area") / 2.0f, 46.0f, 0xE0E0E0, true);
    }
}

