/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.itemblocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class BlockItemTankSink
extends BlockItem {
    public BlockItemTankSink(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        if (stack.hasTag() && !stack.getTag().contains("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.getTag());
            if (fluid != null) {
                list.add((Component)Component.literal((String)("Contains: " + fluid.getDisplayName().getString())).withStyle(ChatFormatting.GREEN));
                list.add((Component)Component.literal((String)(fluid.getAmount() + "Mb/32000Mb")).withStyle(ChatFormatting.BLUE));
            }
        } else {
            list.add((Component)Component.literal((String)"Holds 32000Mb (32 Buckets)").withStyle(ChatFormatting.BLUE));
        }
    }
}

