/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.items;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemGMChickenFeed
extends Item {
    public FeedType type;

    public ItemGMChickenFeed(Item.Properties properties, FeedType typeIn) {
        super(properties);
        this.type = typeIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Level world, List<Component> list, @Nonnull TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"tooltip.chickenfeed_1").withStyle(ChatFormatting.YELLOW));
        list.add((Component)Component.translatable((String)"tooltip.chickenfeed_2").withStyle(ChatFormatting.YELLOW));
        if (this.type == FeedType.MOB && stack.hasTag() && Objects.requireNonNull(stack.getTag()).contains("mguMobName")) {
            list.add((Component)Component.translatable((String)"tooltip.chickenfeed_3").withStyle(ChatFormatting.GREEN).append(" " + stack.getTag().get("mguMobName") + " 'DNA'."));
        }
        if (this.type == FeedType.CURSED) {
            list.add((Component)Component.translatable((String)"tooltip.chickenfeed_4").withStyle(ChatFormatting.YELLOW));
        }
        if (this.type == FeedType.NUTRITIOUS) {
            list.add((Component)Component.translatable((String)"tooltip.chickenfeed_5").withStyle(ChatFormatting.YELLOW));
        }
    }

    public static enum FeedType {
        MOB,
        CURSED,
        NUTRITIOUS;

    }
}

