/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import mob_grinding_utils.network.MGUClientPackets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record ChickenSyncPacket(int chickenID, CompoundTag nbt) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mob_grinding_utils", "chicken_sync");

    public ChickenSyncPacket(LivingEntity chicken, CompoundTag chickenNBT) {
        this(chicken.getId(), chickenNBT);
    }

    public ChickenSyncPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readNbt());
    }

    public static void handle(ChickenSyncPacket message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> MGUClientPackets.HandleChickenSync(message));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.chickenID);
        buf.writeNbt((Tag)this.nbt);
    }

    public ResourceLocation id() {
        return ID;
    }
}

