/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.blocks.BlockFan;
import mob_grinding_utils.config.ServerConfig;
import mob_grinding_utils.inventory.server.ContainerFan;
import mob_grinding_utils.items.ItemFanUpgrade;
import mob_grinding_utils.tile.BEGuiClickable;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityFan
extends TileEntityInventoryHelper
implements MenuProvider,
BEGuiClickable {
    private static final int[] SLOTS = new int[]{0, 1, 2};
    public boolean showRenderBox;
    float xPos;
    float yPos;
    float zPos;
    float xNeg;
    float yNeg;
    float zNeg;

    public TileEntityFan(BlockPos pos, BlockState state) {
        super(ModBlocks.FAN.getTileEntityType(), 3, pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof TileEntityFan) {
            TileEntityFan fan = (TileEntityFan)t;
            if (level.getGameTime() % 2L == 0L && level.getBlockState(pos).getBlock() instanceof BlockFan && ((Boolean)level.getBlockState(pos).getValue((Property)BlockFan.POWERED)).booleanValue()) {
                fan.activateBlock();
            }
            if (!level.isClientSide) {
                fan.setAABBWithModifiers();
            }
        }
    }

    public int getWidthModifier() {
        return this.hasWidthUpgrade() ? ((ItemStack)this.getItems().get(0)).getCount() : 0;
    }

    public int getHeightModifier() {
        return this.hasHeightUpgrade() ? ((ItemStack)this.getItems().get(1)).getCount() : 0;
    }

    public int getSpeedModifier() {
        return this.hasSpeedUpgrade() ? ((ItemStack)this.getItems().get(2)).getCount() : 0;
    }

    public void setAABBWithModifiers() {
        BlockState state2;
        int distance;
        BlockState state = this.getLevel().getBlockState(this.getBlockPos());
        if (!(state.getBlock() instanceof BlockFan)) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)BlockFan.FACING);
        boolean strongBlades = (Boolean)ServerConfig.FAN_REINFORCED_BLADES.get();
        for (distance = 1; distance < 5 + this.getSpeedModifier() && ((state2 = this.getLevel().getBlockState(this.getBlockPos().relative(facing, distance))).getBlock() instanceof AirBlock || !(strongBlades ? state2.canOcclude() : !state2.is(BlockTags.REPLACEABLE_BY_TREES))); ++distance) {
        }
        if (facing == Direction.UP) {
            this.yPos = distance;
            this.yNeg = -1.0f;
            this.xPos = this.getHeightModifier();
            this.xNeg = this.getHeightModifier();
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
        }
        if (facing == Direction.DOWN) {
            this.yNeg = distance;
            this.yPos = -1.0f;
            this.xPos = this.getHeightModifier();
            this.xNeg = this.getHeightModifier();
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
        }
        if (facing == Direction.WEST) {
            this.xNeg = distance;
            this.xPos = -1.0f;
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == Direction.EAST) {
            this.xPos = distance;
            this.xNeg = -1.0f;
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == Direction.NORTH) {
            this.zNeg = distance;
            this.zPos = -1.0f;
            this.xPos = this.getWidthModifier();
            this.xNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == Direction.SOUTH) {
            this.zPos = distance;
            this.zNeg = -1.0f;
            this.xPos = this.getWidthModifier();
            this.xNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 8);
    }

    public AABB getAABBWithModifiers() {
        return new AABB((double)((float)this.getBlockPos().getX() - this.xNeg), (double)((float)this.getBlockPos().getY() - this.yNeg), (double)((float)this.getBlockPos().getZ() - this.zNeg), (double)this.getBlockPos().getX() + 1.0 + (double)this.xPos, (double)this.getBlockPos().getY() + 1.0 + (double)this.yPos, (double)this.getBlockPos().getZ() + 1.0 + (double)this.zPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getAABBForRender() {
        return new AABB((double)(-this.xNeg), (double)(-this.yNeg), (double)(-this.zNeg), 1.0 + (double)this.xPos, 1.0 + (double)this.yPos, 1.0 + (double)this.zPos);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)((float)this.getBlockPos().getX() - this.xNeg), (double)((float)this.getBlockPos().getY() - this.yNeg), (double)((float)this.getBlockPos().getZ() - this.zNeg), (double)this.getBlockPos().getX() + 1.0 + (double)this.xPos, (double)this.getBlockPos().getY() + 1.0 + (double)this.yPos, (double)this.getBlockPos().getZ() + 1.0 + (double)this.zPos);
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.setChanged();
    }

    protected void activateBlock() {
        BlockState state = this.getLevel().getBlockState(this.getBlockPos());
        if (!(state.getBlock() instanceof BlockFan)) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)BlockFan.FACING);
        List list = this.getLevel().getEntitiesOfClass(LivingEntity.class, this.getAABBWithModifiers());
        for (Entity entity : list) {
            if (entity == null || !(entity instanceof LivingEntity)) continue;
            if (facing != Direction.UP && facing != Direction.DOWN) {
                entity.push((double)Mth.sin((float)(facing.getOpposite().toYRot() * 3.141593f / 180.0f)) * 0.5, 0.0, (double)(-Mth.cos((float)(facing.getOpposite().toYRot() * 3.141593f / 180.0f))) * 0.5);
                continue;
            }
            if (facing == Direction.UP) {
                float f = 0.125f;
                Vec3 vec3d = entity.getDeltaMovement();
                entity.setDeltaMovement(vec3d.x, (double)f, vec3d.z);
                entity.push(0.0, 0.25, 0.0);
                entity.fallDistance = 0.0f;
                continue;
            }
            entity.push(0.0, -0.2, 0.0);
        }
    }

    private boolean hasWidthUpgrade() {
        return !((ItemStack)this.getItems().get(0)).isEmpty() && ((ItemStack)this.getItems().get(0)).getItem() == ModItems.FAN_UPGRADE_WIDTH.get();
    }

    private boolean hasHeightUpgrade() {
        return !((ItemStack)this.getItems().get(1)).isEmpty() && ((ItemStack)this.getItems().get(1)).getItem() == ModItems.FAN_UPGRADE_HEIGHT.get();
    }

    private boolean hasSpeedUpgrade() {
        return !((ItemStack)this.getItems().get(2)).isEmpty() && ((ItemStack)this.getItems().get(2)).getItem() == ModItems.FAN_UPGRADE_SPEED.get();
    }

    @Override
    public void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        nbt.putBoolean("showRenderBox", this.showRenderBox);
        nbt.putFloat("xPos", this.xPos);
        nbt.putFloat("yPos", this.yPos);
        nbt.putFloat("zPos", this.zPos);
        nbt.putFloat("xNeg", this.xNeg);
        nbt.putFloat("yNeg", this.yNeg);
        nbt.putFloat("zNeg", this.zNeg);
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.showRenderBox = nbt.getBoolean("showRenderBox");
        this.xPos = nbt.getFloat("xPos");
        this.yPos = nbt.getFloat("yPos");
        this.zPos = nbt.getFloat("zPos");
        this.xNeg = nbt.getFloat("xNeg");
        this.yNeg = nbt.getFloat("yNeg");
        this.zNeg = nbt.getFloat("zNeg");
    }

    @Nonnull
    public CompoundTag getUpdateTag() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.load(packet.getTag());
        this.onContentsChanged();
    }

    public void onContentsChanged() {
        if (!this.getLevel().isClientSide) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.setAABBWithModifiers();
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 8);
            this.setChanged();
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return stack.getItem() instanceof ItemFanUpgrade;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.getItems(), (int)index);
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Nonnull
    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public AbstractContainerMenu createMenu(int windowID, Inventory playerInventory, Player player) {
        return new ContainerFan(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)"block.mob_grinding_utils.fan");
    }

    @Override
    public void buttonClicked(int buttonID) {
        if (buttonID == 0) {
            this.toggleRenderBox();
            this.getLevel().sendBlockUpdated(this.worldPosition, this.getLevel().getBlockState(this.worldPosition), this.getLevel().getBlockState(this.worldPosition), 3);
        }
    }
}

