/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import java.util.List;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.network.TapParticlePacket;
import mob_grinding_utils.tile.TileEntityTank;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class TileEntitySinkTank
extends TileEntityTank {
    public TileEntitySinkTank(BlockPos pos, BlockState state) {
        super(ModBlocks.TANK_SINK.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void serverTick(Level world, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntitySinkTank) {
            TileEntitySinkTank tile = (TileEntitySinkTank)t;
            if (tile.tank.getFluid().isEmpty() || tile.tank.getFluid().containsFluid(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), 1))) {
                tile.captureDroppedXP();
            }
            TileEntityTank.serverTick(world, worldPosition, blockState, t);
        }
    }

    public boolean captureDroppedXP() {
        for (Player player : this.getCaptureXP(this.level, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5)) {
            if (player.isSpectator()) continue;
            int xpAmount = TileEntitySinkTank.getPlayerXP(player);
            if (xpAmount <= 0) {
                return false;
            }
            if (this.tank.getFluidAmount() < this.tank.getCapacity()) {
                this.tank.fill(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), 20), IFluidHandler.FluidAction.EXECUTE);
                TileEntitySinkTank.addPlayerXP(player, -1);
                this.level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 0.1f, 0.5f * ((this.getLevel().random.nextFloat() - this.getLevel().random.nextFloat()) * 0.7f + 1.8f));
                PacketDistributor.TargetPoint particleTarget = new PacketDistributor.TargetPoint((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), 30.0, this.level.dimension());
                PacketDistributor.NEAR.with((Object)particleTarget).send(new CustomPacketPayload[]{new TapParticlePacket(this.getBlockPos().above())});
            }
            return true;
        }
        return false;
    }

    public List<Player> getCaptureXP(Level world, double x, double y, double z) {
        return world.getEntitiesOfClass(Player.class, new AABB(x - 0.45, y - 0.5, z - 0.45, x + 0.45, y + 1.03, z + 0.45), EntitySelector.ENTITY_STILL_ALIVE);
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.totalExperience = experience = TileEntitySinkTank.getPlayerXP(player) + amount;
        player.experienceLevel = TileEntitySinkTank.getLevelForExperience(experience);
        int expForLevel = TileEntitySinkTank.getExperienceForLevel(player.experienceLevel);
        player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
    }

    public static int getPlayerXP(Player player) {
        return TileEntitySinkTank.getExperienceForLevel(player.experienceLevel) + (int)(player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (TileEntitySinkTank.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 17) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level > 16 && level < 32) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }
}

