/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.config.PoserConfig;
import com.mrbysco.armorposer.packets.ArmorStandScreenPayload;
import com.mrbysco.armorposer.packets.ArmorStandSwapPayload;
import com.mrbysco.armorposer.packets.ArmorStandSyncPayload;
import com.mrbysco.armorposer.packets.handler.ClientPayloadHandler;
import com.mrbysco.armorposer.packets.handler.ServerPayloadHandler;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

@Mod(value="armorposer")
public class ArmorPoser {
    public ArmorPoser(IEventBus eventBus) {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PoserConfig.commonSpec);
        eventBus.register(PoserConfig.class);
        eventBus.addListener(this::setupPackets);
    }

    private void setupPackets(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("armorposer");
        registrar.play(Reference.SCREEN_PACKET_ID, ArmorStandScreenPayload::new, handler -> handler.client(ClientPayloadHandler.getInstance()::handleScreenData));
        registrar.play(Reference.SWAP_PACKET_ID, ArmorStandSwapPayload::new, handler -> handler.server(ServerPayloadHandler.getInstance()::handleSwapData));
        registrar.play(Reference.SYNC_PACKET_ID, ArmorStandSyncPayload::new, handler -> handler.server(ServerPayloadHandler.getInstance()::handleSyncData));
    }
}

