/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorStandScreen;
import com.mrbysco.armorposer.client.gui.DeletePoseScreen;
import com.mrbysco.armorposer.client.gui.widgets.PoseEntry;
import com.mrbysco.armorposer.client.gui.widgets.PoseListWidget;
import com.mrbysco.armorposer.poses.UserPoseHandler;
import com.mrbysco.armorposer.util.PoseData;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ArmorPosesScreen
extends Screen {
    private static final int PADDING = 6;
    private PoseListWidget[] poseListWidget = new PoseListWidget[2];
    private PoseListWidget.ListEntry selected = null;
    private List<PoseEntry> poses;
    private final List<PoseEntry> unsortedPoses;
    private List<PoseEntry> userPoses;
    private final List<PoseEntry> unsortedUserPoses;
    private Button applyButton;
    private final int buttonMargin = 1;
    private final int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private EditBox search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;
    public ArmorStandScreen parentScreen;

    public ArmorPosesScreen(ArmorStandScreen parent) {
        super((Component)Component.translatable((String)"armorposer.gui.poses.title"));
        this.parentScreen = parent;
        List rawPoses = Reference.defaultPoseMap.entrySet().stream().map(entry -> new PoseEntry((String)entry.getKey(), (String)entry.getValue(), false)).collect(Collectors.toList());
        this.unsortedPoses = Collections.unmodifiableList(rawPoses);
        Collections.sort(rawPoses);
        this.poses = Collections.unmodifiableList(rawPoses);
        UserPoseHandler.loadUserPoses();
        List rawUserPoses = Reference.userPoses.stream().map(entry -> new PoseEntry((PoseData)entry, true)).collect(Collectors.toList());
        this.unsortedUserPoses = Collections.unmodifiableList(rawUserPoses);
        Collections.sort(rawUserPoses);
        this.userPoses = Collections.unmodifiableList(rawUserPoses);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int centerWidth = this.width / 2;
        int listWidth = this.width / 4 + 20;
        int structureWidth = this.width - listWidth - 18;
        int closeButtonWidth = Math.min(structureWidth, 160);
        int y = this.height - 20 - 6;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).bounds(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).build());
        this.applyButton = Button.builder((Component)Component.translatable((String)"armorposer.gui.poses.selection.apply"), b -> {
            if (this.selected != null) {
                if (!this.selected.userAdded() && this.selected.rawName().equals("random")) {
                    for (int i = 0; i < this.parentScreen.poseTextFields.length - 3; ++i) {
                        float randomRotation = (float)(Math.random() * 70.0 - 35.0);
                        this.parentScreen.poseTextFields[i].setValue(String.valueOf((int)randomRotation));
                    }
                } else {
                    this.parentScreen.readFieldsFromNBT(this.selected.getTag());
                }
                this.parentScreen.textFieldUpdated();
                this.parentScreen.updateEntity(this.selected.getTag());
            }
            this.onClose();
        }).bounds(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.applyButton);
        this.search = new EditBox(this.getScreenFont(), centerWidth - listWidth / 2 + 6 + 1, y -= 20, listWidth - 2, 14, (Component)Component.translatable((String)"armorposer.gui.poses.search"));
        int fullButtonHeight = 32;
        MutableComponent mutableComponent = Component.translatable((String)"armorposer.gui.poses.default");
        int n = this.search.getY();
        Objects.requireNonNull(this.getScreenFont());
        this.poseListWidget[0] = new PoseListWidget(this, (Component)mutableComponent, false, listWidth, fullButtonHeight, n - 9 - 6);
        this.poseListWidget[0].setX(0);
        this.poseListWidget[0].setY(10);
        this.poseListWidget[0].setHeight(this.height);
        MutableComponent mutableComponent2 = Component.translatable((String)"armorposer.gui.poses.user");
        int n2 = this.search.getY();
        Objects.requireNonNull(this.getScreenFont());
        this.poseListWidget[1] = new PoseListWidget(this, (Component)mutableComponent2, true, listWidth, fullButtonHeight, n2 - 9 - 6);
        this.poseListWidget[1].setX(this.width - listWidth);
        this.poseListWidget[1].setY(10);
        this.poseListWidget[1].setHeight(this.height);
        this.addWidget((GuiEventListener)this.search);
        this.addWidget((GuiEventListener)this.poseListWidget[0]);
        this.addWidget((GuiEventListener)this.poseListWidget[1]);
        this.search.setFocused(false);
        this.search.setCanLoseFocus(true);
        int width = listWidth / this.numButtons;
        int x = centerWidth + 6 - width;
        SortType.A_TO_Z.button = Button.builder((Component)SortType.A_TO_Z.getButtonText(), b -> this.resortPoses(SortType.A_TO_Z)).bounds(x, 6, width - 1, 20).build();
        this.addRenderableWidget((GuiEventListener)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = Button.builder((Component)SortType.Z_TO_A.getButtonText(), b -> this.resortPoses(SortType.Z_TO_A)).bounds(x += width + 1, 6, width - 1, 20).build();
        this.addRenderableWidget((GuiEventListener)SortType.Z_TO_A.button);
        this.resortPoses(SortType.A_TO_Z);
        this.updateCache();
    }

    public void tick() {
        if (this.poseListWidget[0].children().contains((Object)this.selected)) {
            this.poseListWidget[0].setSelected((AbstractSelectionList.Entry)this.selected);
            this.poseListWidget[1].setSelected(null);
        } else if (this.poseListWidget[1].children().contains((Object)this.selected)) {
            this.poseListWidget[0].setSelected(null);
            this.poseListWidget[1].setSelected((AbstractSelectionList.Entry)this.selected);
        }
        if (!this.search.getValue().equals(this.lastFilterText)) {
            this.reloadPoses();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadPoses();
            if (this.sortType == SortType.A_TO_Z) {
                Collections.sort(this.poses);
                Collections.sort(this.userPoses);
            } else if (this.sortType == SortType.Z_TO_A) {
                this.poses.sort(Collections.reverseOrder());
                this.userPoses.sort(Collections.reverseOrder());
            }
            this.poseListWidget[0].refreshList(false);
            this.poseListWidget[1].refreshList(true);
            if (this.selected != null) {
                this.selected = this.poseListWidget[0].children().stream().filter(e -> e == this.selected).findFirst().orElse(this.poseListWidget[1].children().stream().filter(e -> e == this.selected).findFirst().orElse(null));
            }
            this.sorted = true;
        }
    }

    private void reloadPoses() {
        this.poses = this.unsortedPoses.stream().filter(entry -> entry.getName().toLowerCase(Locale.ROOT).contains(this.search.getValue().toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        this.userPoses = this.unsortedUserPoses.stream().filter(entry -> entry.getName().toLowerCase(Locale.ROOT).contains(this.search.getValue().toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        this.lastFilterText = this.search.getValue();
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildPoseList(Consumer<T> ListViewConsumer, Function<PoseEntry, T> newEntry) {
        this.poses.forEach(mod -> ListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((PoseEntry)mod)));
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildUserPoseList(Consumer<T> ListViewConsumer, Function<PoseEntry, T> newEntry) {
        this.userPoses.forEach(mod -> ListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((PoseEntry)mod)));
    }

    private void resortPoses(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.active = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.poseListWidget[0].render(guiGraphics, mouseX, mouseY, partialTicks);
        this.poseListWidget[1].render(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        MutableComponent text = Component.translatable((String)"armorposer.gui.poses.search");
        Font font = this.getScreenFont();
        int n = this.width / 2 + 6;
        int n2 = this.search.getY();
        Objects.requireNonNull(this.getScreenFont());
        guiGraphics.drawCenteredString(font, (Component)text, n, n2 - 9 - 2, 0xFFFFFF);
        this.search.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 261 && this.selected != null && this.selected.userAdded()) {
            this.minecraft.setScreen((Screen)new DeletePoseScreen(this.parentScreen, this.selected));
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void setSelected(PoseListWidget.ListEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        this.applyButton.active = this.selected != null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean flag = super.mouseClicked(mouseX, mouseY, button);
        if (button == 1 && this.search.isMouseOver(mouseX, mouseY)) {
            this.search.setValue("");
        }
        return flag;
    }

    public void resize(Minecraft mc, int width, int height) {
        String s = this.search.getValue();
        SortType sort = this.sortType;
        PoseListWidget.ListEntry selected = this.selected;
        this.init(mc, width, height);
        this.search.setValue(s);
        this.selected = selected;
        if (!this.search.getValue().isEmpty()) {
            this.reloadPoses();
        }
        if (sort != SortType.NORMAL) {
            this.resortPoses(sort);
        }
        this.updateCache();
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.parentScreen);
    }

    public Minecraft getScreenMinecraft() {
        return this.minecraft;
    }

    public Font getScreenFont() {
        return this.font;
    }

    private static enum SortType {
        NORMAL,
        A_TO_Z,
        Z_TO_A;

        Button button;

        Component getButtonText() {
            return Component.translatable((String)("armorposer.gui.poses.search." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

