/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.config;

import com.mrbysco.armorposer.Reference;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PoserConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Reference.LOGGER.debug("Loaded {}'s config file {}", (Object)"armorposer", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Reference.LOGGER.debug("{}'s config just got changed on the file system!", (Object)"armorposer");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue enableConfigGui;
        public final ModConfigSpec.BooleanValue enableNameTags;
        public final ModConfigSpec.BooleanValue allowScrolling;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.enableConfigGui = builder.comment("Show the Armor Stand configuration GUI on shift right click").translation("armorposer.config.enableConfigGui.tooltip").define("enableConfigGui", true);
            this.enableNameTags = builder.comment("Allow Armor Stand to be renamed using name tags").translation("armorposer.config.enableNameTags.tooltip").define("enableNameTags", true);
            this.allowScrolling = builder.comment("Allow scrolling to increase / decrease an angle value in the posing screen").translation("armorposer.config.allowScrolling.tooltip").define("allowScrolling", true);
            builder.pop();
        }
    }
}

