/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.data;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.decoration.ArmorStand;

public record SyncData(UUID entityUUID, CompoundTag tag) {
    public void encode(FriendlyByteBuf buf) {
        buf.writeUUID(this.entityUUID);
        buf.writeNbt((Tag)this.tag);
    }

    public static SyncData decode(FriendlyByteBuf packetBuffer) {
        return new SyncData(packetBuffer.readUUID(), packetBuffer.readNbt());
    }

    public void handleData(ArmorStand armorStand) {
        CompoundTag entityTag = armorStand.saveWithoutId(new CompoundTag());
        CompoundTag entityTagCopy = entityTag.copy();
        if (!this.tag.isEmpty()) {
            entityTagCopy.merge(this.tag);
            armorStand.load(entityTagCopy);
            armorStand.setUUID(this.entityUUID);
            ListTag tagList = this.tag.getList("Move", 6);
            double x = tagList.getDouble(0);
            double y = tagList.getDouble(1);
            double z = tagList.getDouble(2);
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                armorStand.setPosRaw(armorStand.getX() + x, armorStand.getY() + y, armorStand.getZ() + z);
            }
        }
    }
}

