/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.util;

import com.unrealdinnerbone.jamd.WorldType;
import com.unrealdinnerbone.trenzalore.api.platform.Services;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class TelerportUtils {
    public static void teleport(Player playerEntity, ResourceKey<Level> toWorldKey, BlockPos blockPos, WorldType registrySet) {
        ServerLevel toWorld = playerEntity.getServer().getLevel(toWorldKey);
        if (toWorld != null) {
            TelerportUtils.findPortalLocation((Level)toWorld, blockPos, registrySet).ifPresentOrElse(portalLocation -> {
                if (toWorld.getBlockState(portalLocation).isAir()) {
                    toWorld.setBlockAndUpdate(portalLocation, ((Block)registrySet.getBlock().get()).defaultBlockState());
                }
                Vec3 portalLocationVec = new Vec3((double)portalLocation.getX() + 0.5, (double)(portalLocation.getY() + 1), (double)portalLocation.getZ() + 0.5);
                Services.PLATFORM.teleport((Entity)playerEntity, toWorld, new PortalInfo(portalLocationVec, playerEntity.getDeltaMovement(), playerEntity.getYRot(), playerEntity.getXRot()));
            }, () -> playerEntity.displayClientMessage((Component)Component.translatable((String)"jamd.invalid.pos"), true));
        } else {
            playerEntity.displayClientMessage((Component)Component.translatable((String)"jamd.invalid.world", (Object[])new Object[]{toWorldKey.location().toString()}), true);
        }
    }

    private static Optional<BlockPos> findPortalLocation(Level worldTo, BlockPos fromPos, WorldType registrySet) {
        if (worldTo.getBlockState(fromPos).is((Block)registrySet.getBlock().get()) && TelerportUtils.isSafeSpawnLocation(worldTo, fromPos)) {
            return Optional.of(fromPos.above());
        }
        int range = 5;
        return Optional.ofNullable(ChunkPos.rangeClosed((ChunkPos)worldTo.getChunkAt(fromPos).getPos(), (int)range).map(chunkPos -> worldTo.getChunk(chunkPos.x, chunkPos.z).getBlockEntitiesPos()).flatMap(Collection::stream).toList().stream().filter(pos -> worldTo.getBlockEntity(pos).getType().equals(registrySet.getBlockEntity().get())).findFirst().orElseGet(() -> {
            BlockPos heightmapPos = worldTo.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, fromPos);
            if (TelerportUtils.forLocationAround(worldTo, heightmapPos.mutable(), fromPos.getX(), fromPos.getZ(), heightmapPos.getY())) {
                return heightmapPos;
            }
            return null;
        }));
    }

    private static boolean forLocationAround(Level levelTo, BlockPos.MutableBlockPos blockPos, int fromX, int fromZ, int y) {
        for (int x = fromX - 6; x < fromX + 6; ++x) {
            for (int z = fromZ - 6; z < fromZ + 6; ++z) {
                blockPos.set(x, y, z);
                if (!TelerportUtils.isSaveLocation(levelTo, blockPos)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSaveLocation(Level levelTo, BlockPos.MutableBlockPos blockPos) {
        BlockState blockState = levelTo.getBlockState((BlockPos)blockPos);
        return blockState.isAir() && TelerportUtils.isSafeSpawnLocation(levelTo, blockPos.above());
    }

    private static boolean isSafeSpawnLocation(Level world, BlockPos blockPos) {
        return world.isInWorldBounds(blockPos) && world.getBlockState(blockPos).isAir() && world.getBlockState(blockPos.above()).isAir();
    }
}

