/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unrealdinnerbone.jamd.util.OreRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.NotNull;

public class CustomFlatLevelGeneratorSettings
extends FlatLevelGeneratorSettings {
    public static final Codec<CustomFlatLevelGeneratorSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Biome.CODEC.fieldOf("biome").forGetter(FlatLevelGeneratorSettings::getBiome), (App)FlatLayerInfo.CODEC.listOf().fieldOf("layers").forGetter(FlatLevelGeneratorSettings::getLayersInfo)).apply((Applicative)instance, instance.stable(CustomFlatLevelGeneratorSettings::create)));

    public static CustomFlatLevelGeneratorSettings create(Holder<Biome> holder, List<FlatLayerInfo> layersInfo) {
        return new CustomFlatLevelGeneratorSettings(holder, layersInfo);
    }

    @NotNull
    public BiomeGenerationSettings adjustGenerationSettings(Holder<Biome> holder) {
        if (!holder.equals((Object)this.biome)) {
            return ((Biome)holder.value()).getGenerationSettings();
        }
        BiomeGenerationSettings.PlainBuilder plainBuilder = new BiomeGenerationSettings.PlainBuilder();
        for (PlacedFeature registeredFeature : OreRegistry.getFeatures(holder)) {
            plainBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Holder.direct((Object)registeredFeature));
        }
        return plainBuilder.build();
    }

    public CustomFlatLevelGeneratorSettings(Holder<Biome> holder, List<FlatLayerInfo> infos) {
        super(Optional.empty(), holder, List.of());
        this.getLayersInfo().clear();
        this.getLayersInfo().addAll(infos);
        this.updateLayers();
    }
}

