/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import com.flanks255.simplygraves.SGBlocks;
import com.flanks255.simplygraves.SimplyGraves;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class BlockReg<B extends Block, I extends Item, T extends BlockEntity>
implements Supplier<B> {
    private String name;
    private final DeferredBlock<B> block;
    private final DeferredItem<I> item;
    private Supplier<BlockEntityType<T>> tile;

    @Override
    public B get() {
        return (B)((Block)this.block.get());
    }

    public String getName() {
        return this.name;
    }

    public BlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier) {
        this.name = name;
        this.block = SGBlocks.BLOCKS.register(name, blockSupplier);
        this.item = SimplyGraves.ITEMS.register(name, () -> (Item)itemSupplier.apply((Block)this.block.get()));
    }

    public BlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier, BlockEntityType.BlockEntitySupplier<T> tileSupplier) {
        this.name = name;
        this.block = SGBlocks.BLOCKS.register(name, blockSupplier);
        this.item = SimplyGraves.ITEMS.register(name, () -> (Item)itemSupplier.apply((Block)this.block.get()));
        this.tile = SGBlocks.BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)tileSupplier, (Block[])new Block[]{(Block)this.block.get()}).build(null));
    }

    public B getBlock() {
        return (B)((Block)this.block.get());
    }

    public I getItem() {
        return (I)((Item)this.item.get());
    }

    @Nonnull
    public BlockEntityType<T> getBlockEntityType() {
        return Objects.requireNonNull(this.tile).get();
    }
}

